; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
;+
; NAME:
;	AX_COLOR
;
;LAST CHANGED: -----------------------------------15-dec-00
;
;PURPOSE:
;	Establish color table and color_index variables for AXIS
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	AX_COLOR
;
;INPUTS: none
;
;KEYWORDS:
;	SHOW - set to show 16 x 16 grid of color table
;   NOLOAD - do not load last user (R,B,G) defined color table (for first time through)
;
;OUTPUTS: none
;
;COMMON BLOCKS:
;	axis_color_common	:
;	ax_top_color_index, ax_black_color_index, ax_white_color_index, $
;	ax_blue_color_index, ax_red_color_index, ax_green_color_index, $
;	ax_cyan_color_index, ax_magenta_color_index, ax_yellow_color_index, $
;	ax_lime_color_index, ax_gold_color_index, ax_rose_color_index, ax_yelgrn_color_index, $
;	ax_purple_color_index, ax_orange_color_index, ax_sky_color_index, ax_beige_color_index
;
;MODIFICATION HISTORY:
; (xx-jun-99 cgz) supplied routine (zimba_color.pro is similar)
; (24-jun-99 aph) converted from zstack_color; set 255=white; 0 = black; 241 = beige
; (29-jun-99 aph) make axis_color_common independent of other commons
; ( 1-jul-99 aph) move hard colors low; add keywourd 'noload'
; ( 8-sep-99 aph) re-activate show keyword
; (31-dec-99 aph) AXIS standard documentation
; (20-feb-00 aph) removed decomposed=0
; (07-apr-00 cgz) restored decomposed=0
;			changed color index names to be generic
;			changed assignment of ax_black_color_index and ax_white_color_index
;			added test for the number of colors and subsequent allocation of the number of colors
; (15-dec-00 cgz) modified no_load operation
;-

PRO ax_color, show=show, noload = noload

@axis_com

; if (!d.n_colors GT 256) then device,decomposed=0
IF keyword_set(show) THEN BEGIN
	device,Get_Visual_Name=thisName, Get_Visual_Depth=thisDepth
	print,thisName,thisDepth,!d.n_colors
ENDIF

IF (!d.n_colors GE 256) THEN BEGIN
	device,decomposed=0
	bottom_color_index	= 16
	top_color_index		= 255
ENDIF ELSE BEGIN
	device,decomposed=0
	bottom_color_index	= 16
	top_color_index		= !d.n_colors - 1
ENDELSE

if keyword_set(noload) then begin
	TVLCT, UserR, UserG, UserB 	; use last set of user-defined color tables
endif
	; establish the custom color scale
	;-----------------------------------------------------------------------
	tvlct,	[  0,255,  0,  0,205,255,255,255, 51,255,255,112,219, 50,  0,255], $
			[  0,  0,150,  0,151,127,  0,255,255,187,127,219,112,125,200,255], $
			[  0,  0,  0,255,  0,  0,255,  0,  0,  0,127,147,219,255,255,255], 0
	indexvec =	[  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15]
;endif

ax_low_color_index	=  bottom_color_index
ax_top_color_index	=  top_color_index
ax_color00_index	=   0		; ax_black_color_index
ax_color01_index	=   1		; ax_red_color_index
ax_color02_index 	=   2		; ax_green_color_index
ax_color03_index	=   3		; ax_blue_color_index
ax_color04_index	=   4		; ax_brown_color_index
ax_color05_index	=   5		; ax_orange_color_index
ax_color06_index	=   6		; ax_magenta_color_index
ax_color07_index	=   7		; ax_yellow_color_index
ax_color08_index	=   8		; ax_lime_color_index
ax_color09_index	=   9		; ax_gold_color_index
ax_color10_index	=  10		; ax_rose_color_index
ax_color11_index	=  11		; ax_yelgrn_color_index
ax_color12_index	=  12		; ax_purple_color_index
ax_color13_index	=  13		; ax_cyan_color_index
ax_color14_index 	=  14		; ax_sky_color_index
ax_color15_index	=  15		; ax_white_color_index

ax_black_color_index = ax_color00_index		; true black always
ax_white_color_index = ax_color15_index		; true white always
ax_image_bkgd_color_index = ax_color00_index	; start as black 
ax_image_axes_color_index = ax_color15_index	; start as white 
ax_plot_bkgd_color_index = ax_color00_index	; start as black 
ax_plot_axes_color_index = ax_color15_index	; start as white 

IF keyword_set(show) THEN begin
	cindex
	tvlct,r,g,b,/get
	colormat = intarr(16,4)
	low = 0
	high = ax_low_color_index

	colormat[*,0] = r[low:high-1]
	colormat[*,1] = g[low:high-1]
	colormat[*,2] = b[low:high-1]
	colormat[*,3] = indexvec
	print,colormat
ENDIF

return
END

