; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_NAME 
; 
;LAST CHANGED: ----------------------------------- 31-dec-99 
; 
;PURPOSE: 
;	This function ;	parse an arbitrary text string as 
; a filename and returns independently the path, main_name, & extension 
; The path ends with the system separator. 
; The separator of the main_name & extension is not returned. 
; 
;CATEGORY: 
;	STAND ALONE: utility 
; 
;CALLING SEQUENCE: 
;	Result = ax_name(FILENAME) 
; 
;CALLED FROM AXIS: 
;	(MANY PLACES) 
 
;INPUTS: 
;	IN_FILENAME - input filename 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	RESULT - 3-element array: 
; (0) = path   (1) = main_name   (2) = extension 
; 
;COMMON BLOCKS: none 
; 
;EXAMPLE: 
; Create a name and parse it 
;	name = 'c:\axis\axis_dev\test-code\circle.axb' 
;	t = ax_name(name) 
;	print, t(0), '   ', t(1), '   ', t(2) 
;   	c:\axis\axis_dev\test-code\   circle   axb 
; 
;MODIFICATION HISTORY: 
; (30-dec-99 aph) AXIS standard documentation 
;- 
 
; 
; INPUT:  string 
; 
; OUTPUT: 3 element string array, t(3) 
;	t(0) = path 
;	t(1) = main_name 
;	t(2) = extension 
; 
; REVISIONS 
; (25-jun-99 aph) first developed 
;- 
 
Function ax_name, in_filename 
 
on_error,2 
 
file = in_filename 
fileshort = file 
path='' 
upos = rstrpos(file,'/')       ; check for either type of subdirectory separators 
wpos = rstrpos(file,'\') 
spos = max([upos,wpos]) 
if (spos ne -1) then begin 
	fileshort=strmid(file,spos+1,strlen(file)) 	; strip leader if it exists 
	path = strmid(file,0,spos+1) 
endif 
 
ext = '' 
spos=strpos(fileshort,'.') 
if (spos ne -1) then begin 
	ext = strmid(fileshort, spos+1,strlen(fileshort)) 
	fileshort=strmid(fileshort,0,spos)		; strip extension if it exists 
endif 
t = strarr(3) 
t(0) = strlowcase(path) 
t(1) = strlowcase(fileshort) 
t(2) = strlowcase(ext) 
 
; print, 'path: |',t(0),'|   name:|',t(1),'|  ext:|',t(2),'|' 
 
return, t 
end 
 
