; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_PEEM_COM.PRO
;
;LAST CHANGED: ----------------------------------- 05-may-02
;
;PURPOSE:
;	This INCLUDE file contains COMMON blocks for AX-PEEM-READ widget.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE: @ax_peem_com
;
; COMMON BLOCKS
;	-------- COMMON PEEM -------------------
;	axis_on			if set, axis2000 running
;	dark_path		dark file path
;	gain_path		gain file dath
;	peem_aoi		Area of Interest file
;	peem_aoi_dark	if set, apply AOI to dark file
;	peem_aoi_gain	if set, apply AOI to gain file
;	peem_bin		binning (nXn) reduced to 1 pixel (default = 1)
;	peem_bits12		if set, all data files are 12-bit (ALS PEEM-2 camera default)
;	peem_col12		gives number of columns to drop for 12-bit readin (to avoid header noise)
;	peem_dark		dark data file
;   peem_dark_avg	if set, average multiple dark files
;   peem_dark_last	number of final dark of a sum of dark files
;	peem_dwell		exposure time (sec)
;   peem_E			energy (eV)
;	peem_first		first/single data file
;	peem_gain		gain data file
;	peem_ID			Widget ID
;	peem_last		last data file
;	peem_median		if set, 3-point median smooth
;	peem_multi		if set, then multiple file conversion to net_CDF
;   peem_ncb        if set, write directly to ncb file (no *.nc)
;	peem_process	string defining action
;				('no correct', dark correct', 'gain correct', dark and gain correct')
;	peem_region		if set, select a subregion, in real space parameters
;	peem_scale		size of pixel (um)
;	peem_sphinx     flag that data format is sphinx
;	peem_struct		output of the ax_peem_read function (structure or a flag)
;	region 			4-vector defining xmin, xmax, ymin, ymax of region
;	source_path		source path
;
; NAMES AND MEANING OF COMMON VARIABLES
; *************************************************************************
; ***********         AX_PEEM_READ PARAMETERS            ******************
; *************************************************************************
;
;
;MODIFICATION HISTORY:

;-
;
COMMON PEEM, axis_on, peem_first, peem_last, peem_dark, peem_dark_avg, peem_dark_last, $
			peem_gain, peem_aoi, peem_sphinx, peem_ncb, $
			peem_aoi_dark, peem_aoi_gain, source_path, dark_path, gain_path, peem_ID, $
            peem_process, peem_median, peem_bits12, peem_col12, peem_multi, $
            peem_E, peem_scale, peem_dwell, peem_bin, peem_region, region, peem_struct