; Copyright(c) 1998-2006 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_READ_ROI
;
;LAST CHANGED: ----------------------------------- 	28-Jan-06
;
; PURPOSE:
;	This function reads a roi and saves it as an image
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:

; for functions:
;	Result = AX_READ_ROI(file-file)
;
; INPUTS:
;	All input parameters are passed as keywords.
;
; KEYWORDS:
;	FILE:  name of file ; if not supplied, program requests it
;   TEMPLATE:   AXB image defining the x, y scales and pixel numbers (*.axb)
;
; OUTPUTS:
;	internal axis format structure is generated
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; RESTRICTIONS:
;	only reads the I_roi portion; format supports storage of both Io_roi and I_roi
;
; MODIFICATION HISTORY:
; (28-jan-06, aph) first version from stack_analyze
;-

function ax_read_roi, file=file, template=template
@axis_com
@bsif_com
@analcom
COMMON volume_data, image_stack

; ---------------- get roi data -----------------
s = 0
if not keyword_set(file) then $
   roi_filename = pickfile2(/read,FILTER='*.roi', /LPATH, DEFPATH=defpath) else $
   roi_filename = file
t = findfile(roi_filename, count=tcount)
if tcount LE 0 then begin
	axis_log, 'cannot find file ' + roi_filename
	return, s
endif
t = ax_name(roi_filename)
fileshort = t(1)
get_lun,lun
openr,lun,roi_filename,/xdr
n_i_roi = long(0)
n_i0_roi = long(0)
i_roi = 0 & i0_roi = 0
readu,lun,n_i_roi,n_i0_roi
IF (n_i_roi NE 0) THEN BEGIN
    i_roi = lonarr(n_i_roi)
    readu,lun,long(i_roi)
ENDIF ELSE BEGIN
    i_roi = 0
ENDELSE
IF (n_i0_roi NE 0) THEN BEGIN
    i0_roi = lonarr(n_i0_roi)
    readu,lun,long(i0_roi)
ENDIF ELSE BEGIN
    i0_roi = 0
ENDELSE
close,lun
free_lun,lun

; ---------------- get template image -----------------
if not keyword_set(template) then template = axb_load()
IF n_tags(template) EQ 0 THEN  begin
	axis_log, 'missing template file'
	return, s
ENDIF
template.d = 0
template.d(i_roi) = 1
template.dl = fileshort + 'roi'

axis_log,'Read ROI from   ' + fileshort

return, template

end
