; Copyright (c) 1998-2005 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_TOMO_READ
;
;LAST CHANGED: ----------------------------------- 14-Dec-05
;
; PURPOSE:
;	This function processes a set of folders containing multi-images stacks for tomography read-in
;
; CATEGORY:
;	Input / output utilty; stand alone
;
; CALLING SEQUENCE:
;	Result = AX_TOMO_READ(FILE=FILE, ONE_IMAGE=ONE_IMAGE, MAP=MAP, STACK=STACK, GROUP=GROUP)
;
; INPUTS: none
;
; KEYWORDS
;	CHANNEL		data channel to read
; 	FILE		list of folders to process
;	ONE_IMAGE  	read in one image at each angle
;	MAP        	read in map (diff of OD of 2 images) at each angle
;	STACK		read in stack of stacks (not yet implemented)
;
; OUTPUTS:
;	folder with selected files
;
; COMMON:
;	AXIS
;	BSIF
;	ANAL
;   VOLUME_DATA
;
; MODIFICATION HISTORY:
; (15-dec-05 aph) first version fur use  in axis and stand alone (for tomography)
;-

Function ax_tomo_read, file=file, one_image=one_image, map=map, stack=stack, $
              channel=channel, group=group

@axis_com
@bsif_com
@analcom
COMMON volume_data, image_stack

axis_on=0
if NOT keyword_set(group) then group = 0 else begin
	t = size(axis_ID, /type)
	if t NE 0 then begin
		group = axis_ID
		axis_on=1
	endif else begin
		axis_on=0
	endelse
endelse

; --------- read list of folders and angles ------------
list_filename=pickfile2(title = "List of tomography folders", fltr='*.lst', /LPATH, DEFPATH=defpath)
get_lun,lun
openr,lun,list_filename
sl_path = ''
readf, lun, sl_path		; check if first line is only a path
t = ax_name(sl_path)
filebase=t(0)+t(1)

widget_control,hourglass=1

; ------ determine number of files to process
got_started = 0
;if strlen(t(1)) EQ 0 or  strlen(t(2)) EQ 0 then begin
while ~ EOF(lun) do begin
	text = ' '
    readf, lun, text
    this_filename = strmid(text, 0, strpos(text,','))
    this_angle = strmid(text, strpos(text,',')+1)
    if (got_started eq 0) then begin
; ------ OK the first line is a path .... but is it the right one ? !!!!
       filename_list = [string(this_filename)]
       angle = [float(this_angle)]
       got_started = 1
    endif else begin
        filename_list = [filename_list,string(this_filename)]
        angle = [angle, float(this_angle)]
    endelse
 endwhile
nfiles=n_elements(filename_list)
filename_ev_msec_list = strarr(nfiles)
close,lun  &  free_lun,lun

; select item to read if not defined by a keyword
if keyword_Set(one_image) then item = 'image'
if keyword_Set(map) then item = 'map'
if keyword_Set(stack) then item = 'stack'
if NOT keyword_Set(one_image) AND $
	NOT keyword_Set(map) AND $
	NOT keyword_Set(stack) then begin
		t=dialog_message('single image? (Yes; No=map)', /question, title='what to read')
		if t EQ 'Yes' then item = 'image' else item = 'map'
endif

; ---- define data channel (if not defined in keyword)

if not keyword_set(channel) then begin
	channel = 1
	if keyword_set(group) then $
	       channel=get_num(prompt='channel', val = channel, group=group) $
	  else channel=get_num(prompt='channel', val = channel)
endif

; ------------- read a single image to set up stack dimension
; read a single file to determine the size of image_stack
sep= ax_sep()
file = sl_path + filename_list(0) + sep + filename_list(0) + '.hdr'
tmp=read_sdf(file, channel=1, /one_image, /silent )
energy = tmp.e
nx = n_elements(tmp.x)
ny = n_elements(tmp.y)
image_stack = fltarr(nx, ny, nfiles)

print, 'Reading tomography data set as defined in ', list_filename

CASE item OF

'image': BEGIN
; ------------- read a single image for each angle
if NOT keyword_set(one_image) then begin
	one_image=1
	if keyword_set(group) then $
	       one_image=get_num(prompt='image number', val = one_image, group=group) $
	  else one_image=get_num(prompt='image number', val = one_image)
endif
file = sl_path + filename_list(0) + sep + filename_list(0) + '.hdr'
;print, 'first read in file: ', file
tmp = read_sdf(file, channel=fix(channel), one_image=one_image, /silent )
axis_log, 'Energy ' + string(energy)
for i = 0, nfiles-1 do begin
	file = sl_path + filename_list(i) + sep + filename_list(i) + '.hdr'
	tmp=read_sdf(file, channel=fix(channel), one_image=one_image, /silent)
	tmp.e = angle(i)
	t = ax_name(file)
	filename_ev_msec_list(i) = filename_list(i) + ' ' + strtrim(string(angle(i)), 2)
	axis_log, strtrim(string(i),2) + ': angle: ' + strtrim(string(tmp.e, format='(f5.1)'),2) + ' file: ' + t(1)
	image_stack(*,*,i) = tmp.d
endfor
END


'map': BEGIN

; define parameters
img_bgnd = 0
img_signal = 1
if keyword_set(group) then $
        img_bgnd = get_num(prompt='image number for BACKGROUND', val = img_bgnd, group=group) $
   else img_bgnd = get_num(prompt='image number for BACKGROUND', val = img_bgnd)
   file = sl_path + filename_list(0) + sep + filename_list(0) + '.hdr'
tmp=read_sdf(file, channel=fix(channel), one_image=img_bgnd, /silent )
axis_log,'Background Energy ' + string(tmp.e)

if keyword_set(group) then $
       img_signal = get_num(prompt='image number for BACKGROUND', val = img_signal, group=group) $
   else img_signal = get_num(prompt='image number for BACKGROUND', val = img_signal)
tmp=read_sdf(file, channel=fix(channel), one_image=img_signal, /silent )
axis_log, 'Signal Energy ' + string(tmp.e)

image_num=[img_bgnd,img_signal]
for i = 0, nfiles-1 do begin
	file = sl_path + filename_list(i) + sep + filename_list(i) + '.hdr'
	tmp=read_sdf(file, channel=1, /map , image_num=image_num, /silent)
	tmp.e = angle(i)
	t = ax_name(file)
	filename_ev_msec_list(i) = filename_list(i) + ' ' + strtrim(string(angle(i)), 2)
	axis_log, strtrim(string(i),2) + ': angle: ' + strtrim(string(tmp.e, format='(f5.1)'),2) + ' file: ' + t(1)
	image_stack(*,*,i) = tmp.d
endfor

END
ELSE:

ENDCASE

; -------- write stack
svec = size(image_stack)
n_cols = nx  & n_rows = ny
x_start = tmp.x(0)
x_stop = tmp.x(n_elements(tmp.x)-1)
y_start = tmp.y(0)
y_stop = tmp.y(n_elements(tmp.y)-1)
xstep = (x_stop - x_start)/n_cols
ystep = (y_stop - y_start)/n_rows

;  ------------ set default filename
t = ax_name(list_filename)
filename = t(0) + t(1) + '.ncb'
filename = pickfile2(/write, filter='*.ncb', /Lpath, $
       defpath = WritePath) ;, get_path=WritePath)
; ---- force extension
t = ax_name(filename)
filename = t(0) + t(1) + '.ncb'
ev = angle
stack_wb, filename
widget_control,hourglass=0

return, filename
END
