; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_ZOOM_CUT
;
;LAST CHANGED: ----------------------------------- 31-dec-01
;
;PURPOSE:
;	This procedure cuts out a region from an AXIS image
; based on numerical limits.
;
;CATEGORY:
;	AXIS: image analysis
;
;CALLING SEQUENCE:
;	AX_ZOOM_CUT, limits=limits
;
;CALLED FROM AXIS:
;	Zoom->Images->Numerical
;
;INPUTS: none - acts on CurBuf
;
;KEYWORDS:
;	LIMITS  [xmin,xmax,ymin,ymax] in data units
;	MESH	[x-pixels, y-pixels] - number of pixels
;
;OUTPUTS:
;	Modified image placed in buffer 0.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (15-nov-99 aph) isolated from axis_c
; (01-jan-00 aph) AXIS standard documentation
; (17-apr-01 aph) added E to output structure
; (29-dec-01 aph) changed to procedure; set up for macro operation
; (31-dec-01 aph) add keyword MESH = [number of x, y pixels] - to ensure equal size outputs
;-

Pro ax_zoom_cut, limits=limits, mesh = mesh
@axis_com
on_error,2

;Get the data for this buffer, check if there is any
HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
IF tmp.t NE '2d' then begin
	WIDGET_CONTROL, Uprompt, SET_VALUE='Zoom.images: not for spectra'
	RETURN
ENDIF
SetGraf,'MainImg'     ; restore image (x,y) scaling parameters
ll = fltarr(2)	& ur = fltarr(2)
if keyword_set(limits) then begin
	ll(0) = limits(0) & ll(1) = limits(2)
	ur(0) = limits(1) & ur(1) = limits(3)
endif else begin
	ll(0) = get_num(prompt='X-min',val=cll(0), group=axis_ID)
	ur(0) = get_num(prompt='X-max',val=cur(0), group=axis_ID)
	ll(1) = get_num(prompt='Y-min',val=cll(1), group=axis_ID)
	ur(1) = get_num(prompt='Y-max',val=cur(1), group=axis_ID)
endelse
cll(0) = ll(0)  &  cll(1) = ll(1)         ; save limits
cur(0) = ur(0)  &  cur(1) = ur(1)
;Set the zoom
!x.range(0) = ll(0) & !x.range(1) = ur(0)
!y.range(0) = ll(1) & !y.range(1) = ur(1)
Ilo = DIndex(ll(0),ll(1),tmp)
Ihi = DIndex(ur(0),ur(1),tmp)
;		print, 'Zoom range '
;		print, 'Data X ', ll(0), ur(0)
;		print, 'Data Y ', ll(1), ur(1)
;		print, 'Device X ', Ilo(0), Ihi(0)
;		print, 'Device Y ', Ilo(1), Ihi(1)
xn = tmp.x(Ilo(0):Ihi(0))	; cut out the zoomed data from tmp
yn = tmp.y(Ilo(1):Ihi(1))
dn = tmp.d(Ilo(0):Ihi(0),Ilo(1):Ihi(1))
tmp = create_struct('t','2d','x',xn,'y',yn,'d',dn, $
	'xl',tmp.xl,'yl',tmp.yl,'dl','ZN ' + tmp.dl, 'E', tmp.e)
if keyword_Set(mesh) then tmp = ax_interp(tmp, mesh=mesh)
CurBuf = 0
HANDLE_VALUE, Data(CurBuf), tmp, /set
Label(CurBuf) = tmp.dl
PlotBuf,CurBuf
return
end
