; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
 
; ************************** AXIS.PRO *********************************** 
; start-up file for AXIS 
; IDL widget for Analysis of X-ray microscopy Image and Spectral data 
; @Hitchcock Enterprises unlimited 
; 
; ****************  AXIS_DEV *** development version ******************** 
; 
; ========================= LAST CHANGED:AXIS 2000 (2.0) (aph 31-Jan-00) 
; 
; AXIS.PRO is a batch file used to load routines needed by the AXIS widget 
; Each file contains one or more PRO's and FUNCTION's which are loaded 
; into memory from one specific location to avoid incompatible code 
; 
; Since Dec-98, based on IDL 5.2; 
; NB IDL 4.0 does not work  for versions after AXIS 1.7 
; 
; ------------ Development History ----------------------------- 
; ( Aug-97 aph) first used when merged spectral & image 
; ( Mar-98 aph) added extend path - needed for UNIX systems 
; (13-Jun-98 aph) incorporated stack pros in start-up 
; (14-jun-98 aph) adapted all {*.pro} to use @--_com includes (not e.g. axis_com.mon) 
; (18-jun-98 aph) 1.4d code changes implemented (plotbuf, sav_hdf, sav_hdfm) 
;                   due to incompatibility with Linux 5.03 version of IDL 
; ( 7-jul-98 aph) new pro files (ln_algn, axis_ini); initialization file in call 
; (29-Dec-98 aph) incorporate new files for version 1.6; convert to aaa_axis.pro 
; (03-jan-99 aph) incorporate new files for version 1.6 
; (11-jan-99 aph) use corrected version of XLOADCT (com error) = ALOADCT 
; (18-jan-99 aph) add ln_load to compile; remove read_re 
; (13-mar-99 aph) adapt to WIN-NT system at ALS 
; (25-mar-99 aph) update for code changes for 1.6b 
; ( 7-jun-99 aph) names consistent with IDL 4 (8.3) 
; (15-jun-99 aph) more new stuff ! 
; (25-jun-99 aph) adapt for Zimba_stack; axis_color 
; ( 9-jul-99 aph) add Refresh 
; (12-aug-99 aph) add ax_svd; finalise 1.7 
; (15-sep-99 aph) added routines for nsls cryo-stxm images 
; (19-sep-99 aph) added ax_wait 
; (25-sep-99 aph) put in zstack_color (full version - Jul99 of zimba; but color low) 
; (26-sep-99 aph) change to axis_on; introduce axis_start widget 
; 				use FULL names (matched to file name) as far as possible 
; (28-sep-99 aph) added AX_COPY, AX_SWITCH 
; ( 3-oct-99 aph) added AX_PARTICLES 
; (14-oct-99 aph) ax_start, ax_sep 
; (17-oct-99 aph) read_cryp, axis_read_image 
; (12-nov-99 aph) ax_pc, ax_colorbar, colorbar 
; (16-nov-99 aph) ax_zoom_cut, resetplots 
; (23-nov-99 aph) line_fit 
; (30-dec-99 aph) mods for version 2.0 
;	added: 	rotate, ax_prof_rad, ax_zoom_cursor, ax_image_add, ax_img_avg 
; 			ax_img_del, ax_nc2gif, ax_spec_delete, deglitch, clip 
; (30-jan-00 aph) try to run with minimal compilation 
; 
;+ 
;NAME: 
;	AXIS 
; 
;LAST CHANGED: ----------------------------------- 31-jan-00 
; 
;PURPOSE: 
;	This procedure compiles (all) files used by the AXIS widget. 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE:  @axis (at the IDL prompt) 
; 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: starts execution of AXIS 
; 
;COMMON BLOCKS: none 
; 
; PROCEDURE 
;	The AXIS batch file is used to start AXIS in order to 
; ensure the  subdirectory from which AXIS is being run 
; contains a complete set of pro files. In principle the IDL auto load 
; or the RESOLVE_ALL routine could be used to achieve this. 
; However, a number of the utility and event call back pro files 
; contain multiple routines that are not visible to RESOLVE_ALL. 
; The working AXIS code directory can be set from the Utilities->Set preferences 
; command in AXIS. The default is C:\axis on WIN machines. 
; IDL library files are loaded as needed 
; 
;MODIFICATION HISTORY: 
; (02-jan-00 aph) AXIS standard documentation. See file for more 
; (31-jan-00 aph) reduce compile time 
;- 
 
 
; ********************   SET STARTING DIRECTORY ********************************* 
; MODIFY the next command to set the default directory to the one with AXIS code 
; ALSO . . . change the corresponding line in the file RESTART.PRO 
; NB when the default directory is changed and axis is then restarted 
; by executing axis_c there is an error (can't find the logo file AXIS.BMP) which 
; the @recover procedure does not correct. In this case, execute RESTART. 
; This will kill the damaged AXIS widget; change to the axis source directory and run axis_c. 
; ********************************************************************************************* 
; ********************     ; CHANGE THIS LINE TO SWITCH Default IDL Path to   ***************** 
cd, 'c:\axis_dev'          ; LOCATION WHERE AXIS code resides                 ***************** 
; ********************     ; see also end of this file for a related change   ***************** 
; ********************************************************************************************* 
; NOTE about PATHS: 
; a subdirectory containing PRO files that AXIS requires can be appended to the existing 
; PATH that IDL is using by executing the command: 
;              !path = !path + EXPAND_PATH('NEW_directory') 
; IF you wish to have IDL search ALL DIRECTORIES contained within a given directory: 
;              !path = !path + EXPAND_PATH('+NEW_directory') 
; on Windows systems: the PATH searched by IDL to find PRO filescan modified in the 
;                     "Preferences" command in the File pull-down menu 
; on UNIX systems:   the PATH must be controlled by using EXPAND_PATH in this start-up file. 
; 
;!path=!path+':'+expand_path('+/data/stxm/axis')  ; include axisdir and subdirectories in path (UNIX) 
; the following gives a flag for IDL 5.2 but is needed for IDL 4.0 
; 
; ******************** 
; DEVICE, decomposed=0 
; ******************** 
; NB the preceding command allows AXIS (IDL 4.0) to have nice colors even when the Window's system 
; is set to higher than 256 colors. However, there are many warnings (errors ?) that get generated as a consequence. 
; AXIS 1.6d and later - does not require this, as it is automatically executed in AX_COLOR, as needed. 
;******************** 
; DEVICE, pseudo=8 
; ******************** 
; adapted from als (jdd) 
; ******************** 
; NB sequence of loading is critical - therefore this alphabetized list 
					; is for documentation ONLY 
; .run file 
; .run gen_read 
; .run graph 
; .run io 
; .run math 
; .run misc 
; .run pick2 
; .run print 
; .run read_a_n 
; .run read_abs 
; .run read_als 
; .run read_xas 
; .run splota 
; .run readstringbig 
; .run spectra 
; .run srotate 
; .run struct 
; .run window 
 
; common stuff (BSIF format) needed for nsls and some conversion 
@bsif_com 
 
.run math, file, struct 
.run io, misc, graph ,window, print 
.run splota 
.run read_als, read_a_n 
.run rdstrbig, rduntlst, rduntlch, rdnumbrs, parsbyts, info 
.run gen_read, spectra, srotate 
 
; ******************** 
; developed for AXIS package (aph) 
; ******************** 
; basic functions used in later pro's 
;.run dindex 
 
; Fanning code for colorbar 
;.run colorbar 
;.run ax_colorbar 
 
; tools 
;.run als2ncdf 
;.run als_specin 
;.run als_spectra 
.run als_spectra_eventcb 
;.run ax_bin 
;.run ax_clear 
;.run ax_color 
;.run ax_conv 
;.run ax_copy 
;.run ax_image_add 
;.run ax_img_avg 
;.run ax_img_del 
;.run ax_imscl 
;.run ax_mesh 
;.run ax_name 
;.run ax_nc2gif 
;.run ax_order 
;.run ax_particles 
;.run ax_pc 
;.run ax_prof_rad 
;.run ax_rd_im 
;.run ax_sep 
;.run ax_spec_delete 
;.run ax_svd 
;.run ax_switch 
;.run ax_xycal 
;.run ax_xydis 
;.run ax_xyscl 
;.run ax_wait 
;.run ax_zoom_cursor 
;.run ax_zoom_cut 
;.run ax_zoom_pan 
;.run axb_load 
;.run axb_save 
;.run axis_add 
;.run axis_app 
;.run axis_ini 
;.run axis_options 
.run axis_options_eventcb 
;.run axis_read_image 
;.run bnl_load 
;.run buffer 
;.run box 
;.run bx_cursor 
;.run clean 
;.run clip 
;.run deglitch 
;.run disp3col 
;.run edgegauss 
;.run file_overwrite 
;.run get_num 
;.run get_path 
;.run get_text 
;.run img_algn 
;.run img_asav 
;.run img_load 
;.run img_warp 
;.run lineclear 
;.run line_fit 
;.run ln_add 
;.run ln_align 
;.run ln_locat 
;.run ln_load 
;.run ln_norm 
;.run ln_subsp 
;.run load_nex 
;.run load_spm 
;.run mbuf 
;.run make_square 
;.run pickfile2 
;.run plotbuf 
;.run plotsect 
;.run rd_peem 
;.run rd_spem 
;.run read_a_n 
;.run read_als 
;.run read_axm 
;.run read_cryo 
;.run read_mef 
;.run read_phi 
;.run read_tof 
;.run refresh 
;.run resetplots 
;.run sav_als 
;.run sav_hdf 
;.run sav_hdfm 
;.run setgraf 
;.run sav_nsls 
;.run spc_load 
;.run spc_save 
;.run thumblbls 
;.run thumbzoom 
;.run tif_load 
;.run tif2ncdf 
;.run tifrd_im 
;.run wrstx_ax 
;.run xas1 
;.run xas2 
 
; ******************** 
; stuff for nsls files: adapted from nsls (cj) (NB .run bsif_common may work) 
; ******************** 
@bsif_com 
;.run copy_bytes 
;.run cryo_to_stxm 
;.run init_sd 
;.run init_stxm_sd 
;.run read_bnl 
;.run read_sxm 
;.run read_bsp 
;.run sxm_ipar 
;.run sxm_fileexists 
;.run sxm_readfile 
;.run sxm_strclean 
;.run write_stxm 
 
 
; ******************** 
; stuff for stacks (aph modified cjj files of Jun-98) 
; ******************** 
;.run align 
;.run stack_align 
;.run stack_analyze 
;.run stack_buildlist 
;.run stack_fit 
;.run stack_list 
;.run read_mapper 
;.run stack_movie 
;.run stack_plot_spectrum 
;.run stack_rb 
;.run stack_readlist 
;.run read_stxm 
;.run stack_wb 
;.run stack_writelist 
;.run write_spectrum 
;.run write_ncdf 
;.run wt_spec 
 
; ******************** 
; stuff for Z_stacks (Zimba files) 
; ******************** 
;.run zimba_run 
;.run zstack_analyze 
;; NB zstack_color must come before zstack_color 
.run zstack_color 
;.run zstack_buildlist 
;.run zstack_readlist 
;.run zstack_align_images 
;.run zstack_shift 
;.run zstack_tune 
;.run zstack_align 
;.run zstack_manalign 
;.run zstack_save 
;.run zstack_profile 
;.run zstack_spectra 
 
; ******************** 
; stuff to load SF (Henke calculator for X-ray absorption parameters) 
; ******************** 
;.run photon_conv 
;.run string2file 
;.run uniq 
.run sf 
; RESOLVE_ALL 
SF_INIT, 'c:\axis\sfdata\' 
 
 
; ******************** 
; run the main code 
; MODIFY the start_file name to the one which you use for your system 
; ******************** 
axis_c, start_file = 'axis.ini' 
