; Copyright (c) 1998-2004 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AXIS_LOG
;
;LAST CHANGED: ----------------------------------- 	16-jun-05
;
; PURPOSE:
;	This procedure displays messages in the aXis2000 log buffer, the IDL log area
; and (when implemented!!) the saved log file for a session
;
; CATEGORY:
;	utility.
;
; CALLING SEQUENCE:
;	AXIS_LOG, TEXT, CLEAR = clear, CLOSE = close, OPEN = open
;
; INPUTS:
;   TEXT   text string to display
;
; KEYWORDS:
;	CLEAR	clear the aXis2000 log buffer (DEFAULT is to append)
;	CLOSE	close current session log file
;	OPEN	open a session log file (close any existing open log)
;
; OUTPUTS:
;	Display in Uprompt Widget_Text box
;	print to IDL log and (optionally) a log file
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; SIDE EFFECTS: none
;
; RESTRICTIONS:
;	Log file not yet implemented
;
; MODIFICATION HISTORY:
; (14-sep-04 aph) first created
; (16-jun-05 aph) ensure works outside axis2k
; (13-Nov-05 aph) force log_last_line to be scalar
;-

PRO AXIS_LOG, TEXT, CLEAR = clear, CLOSE = close, OPEN = open
@axis_com
on_error,2

if keyword_set(clear) then begin
	WIDGET_CONTROL, Uprompt,  Bad_ID = badID,  Set_Value = ' '
	log_last_line = 0
endif

print, text
if n_elements(log_last_line) EQ 0 then log_last_line = 0
WIDGET_CONTROL, Uprompt,  Bad_ID = badID, $
     Set_Value = text, /append, set_text_top_line = log_last_line
log_last_line = fix(log_last_line + floor(1. + strlen(text)/28))
end
