; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		PEM_LOAD
;
;LAST CHANGED: ----------------------------------- 02-jul-02 (aph)
;
; PURPOSE:
;	This function reada an ALS-PEEM 2 NEXAFS format file
; It assumes col(1) = Energy (eV)  and col(3) = signal
;
; CATEGORY: spectral input
; called from AXIS~READ~ALS-PEEM
;
; CALLING SEQUENCE:
;	Result = PEM_LOAD(file=file, filter=filter, NOF=nof, $
;             error=err, print_source = print_source, _extra=e)
;
; INPUTS:
;	All input parameters are passed as keywords.
;
; KEYWORDS:
;	FILE:	filename
;	FILTER:	optional user selectable filter (default = '*.'
;	NOF:	no filter (*.*)
;	PRINT_SOURCE:	if set to 1; print input file as it is read
;	_EXTRA_E:	forward other parameters
;
; OUTPUTS: none
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; ( 9-aug-97 aph) broke out of spectral; TYPE defined
; (21-jan-98 aph) added s.dn component to 1d structure to be axis-compatible
; (20-feb-98 aph) set-up to read 2-col only data
; ( 6-mar-98 aph) read *.txt - 2 column ascii files
; ( 7-jun-98 aph) corrected read *.txt ('un' case) to get all data points
; (10-jul-98 aph) retired "*.spc" nomenclature - use *.txt extension
; (13-May-99 aph) set up for multicolumn, skip header reading
; (15-May-99 aph) adapt spc_load to get ALS-PEEM 2 format files
; (25-jun-99 aph) use only fileshort
; ( 7-jul-99 aph) FREE_LUN as well as close
; (29-dec-00 aph) set filter to '*.' ; standard header; add file
; (14-jan-01 aph) set filter to '*.*' since '*.' EXCLUDES files of *. character !!
; (12-aug-01 aph) add title to pickfile dialog
; (12-may-02 aph) correct header name format
; (02-jul-02 aph) troubleshooting 5.5 error
;-

Function pem_load, file=file, filter=filter, NOF=nof, print_source = print_source, _extra=e

 on_error,2
 @axis_com

if not keyword_set(file) then begin
	 fltr='*.*'
	 if keyword_set(nof) then fltr='*.*'
	 if keyword_set(filter) then fltr=filter
	 file = pickfile2(/READ, FILTER=fltr, /LPATH, DEFPATH=defpath, title = 'Select PEEM energy file')
endif
 if strlen(file) GT 0 THEN BEGIN  ; bail-out if no filename
	openr, iunit, file, /get_lun, error=err
	test = ''
;	reread:
;	on_ioerror, reread
	readf, iunit, test
	print, test
;	wid_exist = WIDGET_INFO(/active)
;	print, 'Select: 0 to skip line, 1 to define columns'
;	if wid_exist EQ 1 then  WIDGET_CONTROL, Uprompt, SET_VALUE=test + ' Select: 0=skip line, 1=define columns'
;	t=get_num(Prompt='action',Val=1)
;	if t EQ 0 then goto, reread
;	print, 'Select columns for x, y'
	cx = 1  & cy = 3
;		cx=get_num(Prompt='x-col',Val=cx)
;		cy=get_num(Prompt='y-col',Val=cy)
	ncol = cy & if cx GT cy then ncol = cx
	data_line = fltarr(ncol)
	on_ioerror, end_of_file
	x=fltarr(999)  &  y = fltarr(999)
	for i = 0, 999 do begin
		readf, iunit, data_line
		if keyword_set(print_source) then print, data_line
		x(i) = data_line(cx-1)
		y(i) = data_line(cy-1)
	endfor
	end_of_file:
	np=i
	name_bits = ax_name(file)
	fileshort = name_bits(1)
	s={t:'1d', d: y(0:np-1), x: x(0:np-1), xl: 'X', dn:x(0:np-1), dl: fileshort}
    print, np,' point spectrum read from file: ', file
	close, iunit & free_lun, iunit
endif else begin 	; go here if user pushes 'cancel'
    print, ' file name of zero length. Read aborted'
    s=0
endelse
return, s
end