; Copyright (c) 1998-2005 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	SAV_NSLS.PRO
;
;LAST CHANGED: ----------------------------------- 15-Dec-05
;
; PURPOSE:
; writes 2d-STRUCTURE and BSIF_COMMON info into NSLS netCDF format
; It places the Z-values of the image (in tmp structure)and associated information
; into the BSIF_COMMON variables:
;   image_data (the array which holds the image - possibly several
;		planes deep for I, IO, CLOCK)
;   x_normal, y_normal, rotated, x_title, y_title
;
; CATEGORY:
;	Stack analysis and stand alone.
; 	Called from aXis2000 by images~nsls~old(*.nc)
;
; CALLING SEQUENCE:
;   SAV_NSLS, TMP, FLTR=FLTR, FILE=FILE
;
; INPUTS
;	TMP		axis format image
;
; KEYWORDS
;	FLTR	name of filter
;	FILE	name of file
;
; COMMON BLOCKS
;	axis_com	common for AXIS2000
;	BSIF_COM	common for NetCDF files
;
; -------------------- REVISION HISTORY --------------------
; (xx-may-98 aph) first developed
; (14-jun-98 aph) axis_com, bsif_com
; (29-dec-98 aph) added rescale for small dynamic range real data.
; (11-jan-99 aph) remove multiple print messages; BadID
; (09-aug-99 aph) remove scaling as now save using float if needed
; (14-oct-99 aph) store correct energy as sd.wavelength
; (09-jan-00 aph) add hourglass for slow saves
; (15-dec-05 aph) tracking integer error; axis_log ; standard header
;-

function sav_nsls, tmp, fltr=fltr , file=file

on_error,2

@axis_com
@bsif_com
;@img_com
;init_common		; sets up image common values
;init_stxm_sd,sd

if not keyword_set(file) then begin  ;popup file dialog box if name not given
   if not keyword_set(fltr) then fltr='*.nc'
   file=PICKFILE2(/Write, FILTER=fltr, /LPATH, DEFPATH=defpath)
 endif

IF strlen(file) GT 0 THEN BEGIN
  	spos=strpos(file,'.')
	if (spos ne -1) then file=strmid(file,0,spos)		  ; force 'nc' extension
	file=strlowcase(file + '.nc')

	if widget_info(/active) EQ 1 then widget_control, /hourglass

; Load net_CDF variable with information from image file
; this is what wrst_ax writes out !
;ncdf_attput, cdfid, image_data_id, "x_normal", x_normal
;ncdf_attput, cdfid, image_data_id, "y_normal", y_normal
;ncdf_attput, cdfid, image_data_id, "rotated", rotated
;ncdf_attput, cdfid, image_data_id, "x_start", x_start
;ncdf_attput, cdfid, image_data_id, "x_stop", x_stop
;ncdf_attput, cdfid, image_data_id, "y_start", y_start
;ncdf_attput, cdfid, image_data_id, "y_stop", y_stop
;ncdf_attput, cdfid, image_data_id, "x_title", x_title
;ncdf_attput, cdfid, image_data_id, "y_title", y_title
	x_start = float(0)
	x_step = float(0)
	y_start = float(0)
	y_step = float(0)
	n_cols = fix(0)
	n_rows = fix(0)
	x_start = tmp.x(0)
	x_stop = tmp.x(n_elements(tmp.x)-1)
	y_start = tmp.y(0)
	y_stop = tmp.y(n_elements(tmp.y)-1)
	x_title = 'X'
	y_title = 'Y'
	x_normal=1
	y_normal=1
	rotated=0

; -------- scale tmp.d to avoid losing image quality when rounding to integers
; (aph 15-aug-99) Turns out that NetCDF format can be FLOATS !
;        image_data_type='float' is likely needed
	scale = 1.
;	if(max(tmp.d) - min(tmp.d) LT 20 or max(abs(tmp.d)) GT 32767) then begin
;		scale = 32000./max(abs(tmp.d))
;		tmp.d = tmp.d * scale
;	endif

	image_data = fltarr(n_elements(tmp.x),n_elements(tmp.y),2)
	image_data(*,*,0) = float(tmp.d)
	image_data(*,*,1) = 1.

;	print, Format = '(A, "  E=",F7.3, "(eV).  Dwell=", f4.2 ,"(ms)")', $
;		file, energy, sd.dwell_time
	data_title =  byte(file)
	image_title = byte(file)
	sd.clock_frequency = 1.

	test = where(tag_names(tmp) EQ 'E',count)
	if count EQ 1 then energy = tmp.e else energy = 0.

	if energy EQ 0 then energy = 12398./sd.wavelength  ; use sd.wavelength if necessary

;	print, 'wavelength=', sd.wavelength, '  E=', energy
	wrstx_ax,file

	t = ax_name(file)
	axis_log, 'NSLS-image wrote to ' + t(1)

ENDIF
return, file
END
