; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		STACK_MAKE
;
;LAST CHANGED: ----------------------------------- 12-may-02
;
; PURPOSE:
;	This procedure generates a stack from the product of an image times a spectrum.
; Typically this would be used to strip out a component from a stack, or for simulations.
;
; CATEGORY:
;	Stack analysis
;
; CALLING SEQUENCE:
;	STACK_MAKE, SPEC, IMAGE
;
; INPUTS:
;	SPEC  - 1-d axis structure which has spectrum of the component
;	IMAGE - 2-d axis structure which has image (typically component map)
;
; KEYWORDS: none
;
; OUTPUTS:
;	The stack is saved to disk
;
; COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;	analcom
;	COMMON volume_data, image_stack
;	bsif_com
;
; MODIFICATION HISTORY:
; (11-apr-00 aph) first version
; (10-nov-00 aph) corrected infor for *.dat file
; (29-jan-01 aph) defined energy array (eV) and filename_ev_msec_list
; (12-may-02 aph) correct header name format
;-
PRO stack_make, spec, image

@axis_com
@analcom
COMMON volume_data, image_stack
@bsif_com

; generate image_stack from spec*image
widget_control,/hourglass
nx = n_elements(image.x)  &  ny = n_elements(image.y)
nimg =  n_elements(spec.x)
image_stack=fltarr(nx, ny, nimg)

for i = 0, nimg-1 do image_stack(*,*,i)= spec.d(i)*image.d(*,*)

WIDGET_CONTROL, Uprompt, SET_VALUE='save stack'
file = pickfile2(/WRITE, FILTER='*.ncb', /LPATH)
if strlen(file) GT 0 then begin
	n_cols = nx
	n_rows = ny
	xstep = image.x(1) - image.x(0)
	x_start = image.x(0)
	x_stop  = image.x(nx-1)
	ystep = image.y(1) - image.y(0)
	y_start = image.y(0)
	y_stop  = image.y(ny-1)
	t = ax_name(file) & fileshort=t(1)
; generate E array
	ev = spec.x
; generate label array
	filename_ev_msec_list = strarr(nimg)
	FOR i=0,nimg-1 DO BEGIN
    	str = string(format='(a7,i3,a9)', fileshort, i,'')
    	strput, str,strtrim(string(ev(i),format='(f10.2)'),2),11
	    filename_ev_msec_list(i) = str
	ENDFOR
	stack_wb, file
endif
end

