; Copyright (c) 1998-2004 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	TIF_CONVERT_COM.PRO
;
;LAST CHANGED: ----------------------------------- 13-jun-05
;
;PURPOSE:
;	This INCLUDE file contains COMMON blocks for  TIF_CONVERT
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE: @tif_convert_com
;
; NAMES AND MEANING OF COMMON VARIABLES
; *************************************************************************
; ***********         TIF_CONVERT COMMON PARAMETERS      ******************
; *************************************************************************

;  COMMON tif_convert_common,	 $
;	tif_convert_par  - widget values
;	pathsep			-  path for files
;	bits12			-  1 = 12bit, 0 =16bit
;	ccd_bgnd		-  No of counts in average CCD background
;	smth			-  1 = median smooth
;	bin				-  nxn binning
;	white			- file for CCD pattern correction
;	start			-
;	ncb_switch		- 1= store as binary, 0 = store as separate *.nc files
;	pix_siz_nm		-  nm/pixel
;	tif_signed		- 1 = signed, 0 = unsigned
;	tif_region		- xmin, xmax, ymin, ymax - pixel limits o fregion of image to convert
;	gotalist		- flag indicating set of files have been selected (1) or not (0)
;	filename_list2	- list of output files
;	spectrum_path	- path to spectrum file
;	spectrum_file	- name of spectrum file
;	spectrum_flag	- spectrum 1 = read, 0 = not read
;	n_tif_files		- number of tif files
;	tif_path		- input path
;	nc_filebase		- output filename base
;	nc_path			- output path
;	lox_flag		- 1 = Lox, 0 = other (used in other programs)
;	microscope		- current type of microscope (string)
;
COMMON tif_convert_common,	 $
	tif_convert_par, 	$
	pathsep, bits12, ccd_bgnd,	$
	smth, bin, white, start, ncb_switch, pix_siz_nm, tif_signed, tif_region, $
	gotalist, filename_list2, spectrum_path, spectrum_file, spectrum_flag,	$
	n_tif_files, tif_path, nc_filebase, nc_path, lox_flag, microscope
