; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
;+
;NAME: WT_SPEC.PRO
;
;LAST CHANGED: ----------------------------------- 30-Nov-00
;
; PURPOSE:
;	This procedure writes out spectra.
; The data and filename are passed to the routine as  call parameters.
;
; CATEGORY:
;	spectral processing
;
; CALLING SEQUENCE:
; for procedures:
;	WT_SPEC var1, var2, filename
;
; INPUTS:
; 	var1		energies
;	var2		intensities
;	filename	name for file to write (includes path)
;
; KEYWORDS: none
;
; OUTPUTS:
;	If 'filename' can be created, an ascii file is written.
;	If 'filename' cannot be created, an error message is written to the IDL log.
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY
; (08-jun-95 aps) created by A. P. Smith
; (06-mar-96 aps) incorporate automatic reading ofarray size
; (08-jan-99 aph) error handling and lun not forced to be 1 (!)
; (30-nov-00 aph) moved close to fix bug found by gary mitchell
;-
pro wt_spec, var1, var2, filename

@axis_com
num_pnts = n_elements(var1)

openw, lun, /get_lun, filename, error=err
if err EQ 0 then begin
	for i=0, num_pnts-1 do printf, lun, var1(i), var2(i), format='(f,f)'
	close, lun
	free_lun, lun
endif else begin
	print, 'Error on attempt to open ', filename
	WIDGET_CONTROL, Uprompt, Bad_ID = badID, Set_Value = 'File open error for ' + filename
endelse

return
end


