; Copyright (c) 1998-2004 A.P. Hitchcock  All rights reserved
;+
;NAME:
;  LN_ADD
;
;LAST CHANGED: ----------------------------------- 13-may-04
;
; PURPOSE:
;	This procedure adds contents of lines to generate:
;  SPECTRA from line scans - sum horizontally (default) or
;  Intensity profiles over a range of E  - add vertical by setting VERTICAL keyword
;
; CATEGORY:
;	Image & linescan processing; captive to AXIS
;
; CALLING SEQUENCE:
;	 LN_ADD  [, VERTICAL=vertical]
;
; INPUTS: none
;
; KEYWORDS:
;	VERTICAL	add vertical lines
;
; OUTPUTS:
;	summed lines displayed in buffer 9
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; SIDE EFFECTS: none known
;
; MODIFICATION HISTORY:
; (01-jan-99 aph) segregated from aaa-axis; merged horizontal & vertical
; (01-mar-00 aph) add groupID to buffer, get_text
; (10-may-01 aph) standard header; save limits
; (02-may-04 aph) modify header
; (13-may-04 aph) use Dialog_message
;-

PRO ln_add, vertical = vertical
on_error,2
@axis_com

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
IF tmp.t EQ '2d' then begin
	SetGraf, 'MainImg'      ; restore MainImg scaling parameters
	test = dialog_message(/question, 'Define lines numerically?',default_no=Ylock(0))
	Ylock(0) = 0
	if test EQ 'Yes' then begin
		YLock(0) = 1
		lower = get_num(Prompt = 'lower', val = cll(0), group = axis_ID)
		cll(0) = lower
		upper = get_num(Prompt = 'upper', val = cll(1), group = axis_ID)
		cll(1) = upper
		if keyword_set(vertical) then begin
			CurInd = Dindex(lower, tmp.y(1), tmp) & IndX1 = CurInd(0)
			CurInd = Dindex(upper, tmp.y(1), tmp) & IndX2 = CurInd(0)
		endif else 	begin
			CurInd = Dindex(tmp.x(1), lower, tmp) & IndY1 = CurInd(1)
			CurInd = Dindex(tmp.x(1), upper, tmp) & IndY2 = CurInd(1)
		endelse
	endif else begin
		WIDGET_CONTROL, Uprompt, SET_VALUE='Linescan.Add: select pt #1'
		CURSOR, x1, y1, /UP, /DATA         ;Get two y-cursor points from the user
		CurInd = DIndex(x1(0),y1(0),tmp)  ;Get index of data points closest to cursor
		;	print,x1,y1,min(tmp.y), max(tmp.y), CurInd
		IndX1 = CurInd(0) & IndY1 = CurInd(1)
		if keyword_set(vertical) then $
		    plots, [x1(0),x1(0)],[tmp.y(0),max(tmp.y)],/data, thick=1 , color=255 $
		else $
			plots, [tmp.x(0),max(tmp.x)], [y1(0),y1(0)],/data, thick=1 , color=255
		WIDGET_CONTROL, Uprompt, SET_VALUE='Linescan.Add: select pt #2'
		CURSOR, x2, y2, /UP, /DATA
		if keyword_set(vertical) then $
		    plots, [x2(0),x2(0)],[tmp.y(0),max(tmp.y)],/data, thick=1 , color=255 $
		else $
		    plots, [tmp.x(0),max(tmp.x)], [y2(0),y2(0)],/data, thick=1 , color=255
		CurInd = DIndex(x2(0),y2(0),tmp)
		;	print,x2,y2,CurInd
		IndX2 = CurInd(0) & IndY2 = CurInd(1)
		if IndX1 GT IndX2 then begin
			tin = IndX1
			IndX1 = IndX2
			IndX2 = tin
		endif
		if IndY1 GT IndY2 then begin
			tin = IndY1
			IndY1 = IndY2
			IndY2 = tin
		endif
;  save current values of the limits for later use
 		if keyword_set(vertical) then begin
			cll(0) = tmp.x(IndX1) & cll(1) = tmp.x(IndX2)
		endif else 	begin
			cll(0) = tmp.y(IndY1) & cll(1) = tmp.y(IndY2)
		endelse
	endelse
	if keyword_set(vertical) then $
	WIDGET_CONTROL, Uprompt, SET_VALUE='sum lines '+strcompress(string(IndX1))+ $
		' to '+strcompress((IndX2)) $
	else $
	WIDGET_CONTROL, Uprompt, SET_VALUE='sum lines '+strcompress(string(IndY1))+ $
		' to '+strcompress(string(IndY2))

	IF keyword_set(vertical) then BEGIN
		spec = fltarr(n_elements(tmp.y))
		for i = indx1,indx2 do spec = spec + tmp.d(i,*)
		spec = spec /(indx2-indx1+1)
		wset, YZPlot
	  	PLOT, spec, tmp.y, xstyle=1,ystyle=1,charsize=0.7, thick = 2, $
				xmargin=[4,2], ymargin=[2,1], $
	  			symsize=0.5, psym=Line_Sym, color=0, background=255
	ENDIF ELSE BEGIN
		spec = fltarr(n_elements(tmp.x))
		for i = indy1,indy2 do spec = spec + tmp.d(*,i)
		spec = spec /(indy2-indy1+1)
		wset, XZPlot
	  	PLOT, tmp.x, spec, xstyle=1,ystyle=1,charsize=0.7, thick = 2, $
				xmargin=[4,2], ymargin=[2,1], $
	  			symsize=0.5, psym=Line_Sym, color=0, background=255
	ENDELSE

	bt = Buffer(group = axis_ID)  	;Get buffer from user
	if bt NE -1 THEN BEGIN
		tlbl = get_text(prompt='Label',VAL=tmp.dl, group = axis_ID)
		if keyword_set(vertical) then begin
			x1 = [tmp.x(IndX1), tmp.x(IndX2)]
		   	x_lbl = string(format='("Position (um)    sum: ",f7.2," to ",f7.2," eV")',x1(0), x1(1))
	  	   	tsp = {t:'1d',x:tmp.y, d:spec, xl:x_lbl, dn:spec, dl:tlbl}
		endif else begin
			y1 = [tmp.y(IndY1), tmp.y(IndY2)]
		  	x_lbl = string(format='("Energy (eV)    sum: ",f7.2," to ",f7.2," um")',y1(0), y1(1))
		  	tsp = {t:'1d',x:tmp.x, d:spec, xl:x_lbl, dn:spec, dl:tlbl}
		endelse
	   	HANDLE_VALUE, Data(bt), tsp, /set  ;Copy it to new buffer
	   	Label(bt) = tsp.dl
	   	CurBuf = bt
	   	PlotBuf,CurBuf
	endif
endif ELSE WIDGET_CONTROL, UPrompt, Set_Value = 'Linescan.Add - only for linescans or images'
END