; Copyright (c) 2007 A. Scholl  All rights reserved
;+
;NAME:
;		READ_P3B
;
;LAST CHANGED: ----------------------------------- 	20-Jan-07
;
; PURPOSE:
;	This function reads a ALS PEEM3 image
; (IDL windows binary with a structure defining microscope parameters)
;
; CATEGORY:
;	utility
;
; CALLING SEQUENCE:
;	Result =  Read_P3B, Filename, TAGS = tags, NTAGS = numtags
;
; INPUTS:
;	Filename	name of file (ext = '*.p3b')
;
; KEYWORDS:
;	TAGS	predefined structure which extracts from embeded parameter structure
;	NTAGS	number of tags in predefined variable
;
; OUTPUTS:
;	RESULT	2-d array with data, and TAGS structure, if requested
;
; COMMON BLOCKS: none
;
;
; MODIFICATION HISTORY:
; (20-Jan-07 aph) extracted from filetype_p3b.pro (20-jan-07 version of A. Scholl)
;-

function Read_P3B, Filename, TAGS = tags, NTAGS = numtags

	OPENR, Unit, Filename, /GET_LUN
	ftags = ReadTags(Unit, NTAGS = numtags)
	CLOSE, Unit
	FREE_LUN, Unit
	if ARG_PRESENT(tags) then begin
		tagnames = TAG_NAMES(ftags)
		first = 1B
		tags = 0
		for i = 0, numtags-1 do begin
			if tagnames[i] eq 'DIMX' then continue
			if tagnames[i] eq 'DIMY' then continue
			if tagnames[i] eq 'DATA' then continue
			if tagnames[i] eq 'PIXTYPE' then continue
			tags = first ? CREATE_STRUCT(tagnames[i],ftags.(i)) : CREATE_STRUCT(tags, tagnames[i],ftags.(i))
			first = 0B
		endfor
		numtags = SIZE(tags, /TYPE) eq 8? N_TAGS(tags) : 0
	endif
	return, REFORM(ftags.Data, ftags.DimX, ftags.DimY, /OVERWRITE)

end