PRO savHDF, tmp, fltr=fltr, file=file 
;+ 
; PRO savHDF, tmp, fltr=fltr, file=file 
; ----------------------------------- last changed: 18-jun-98 
; writes AXIS 2d-structure as an HDF 2d scientific data format 
; used to transfer files from AXIS to ENVI 
;- 
; -------------- DEVELOPMENT HISTORY ---------------------- 
; (aph 18-jun-98) adapted from MakeHFDdata in idl40\examples\hdf_netcdf\hdf_rdwr.pro 
 
on_error,2 
@axis_com
IF n_tags(tmp) NE 0 then BEGIN 
  if tmp.t EQ '2d' then BEGIN 
	IF NOT keyword_set(file) then BEGIN 
	     if not keyword_set(fltr) then fltr='*.hdf' 
   		 file=PICKFILE2(/Write, FILTER=fltr, /LPATH, DEFPATH=defpath) 
    endif 
 
;	Create (or overwrite) a Scientific Data Set (SDS) 
	HDF_DFSD_SETINFO,	$ 
		/CLEAR,		$		; Reset SDS internal vars. 
		/FLOAT,		$		; Data is floating point 
		DIMS=[n_elements(tmp.x),n_elements(tmp.y)],	$ 
		LABEL=tmp.dl, $		; TITLE=... 
		UNIT="um"			; UNITS=... 
	HDF_DFSD_DIMSET, 0, LABEL=tmp.xl 
	HDF_DFSD_DIMSET, 1, LABEL=tmp.yl 
	;	Create and write the data 
	HDF_DFSD_ADDDATA, file, tmp.d, /OVERWRITE 
   endif 
ENDIF 
END 
