; Copyright (c) 1998-2006 A.P. Hitchcock  All rights reserved
;+
;NAME:
;  STACK_APPEND
;
;LAST CHANGED: ----------------------------------- 12-Nov-06
;
; PURPOSE:
;	This procedure appends two stacks if they have the same  pixel dimensions
;
; CATEGORY:
;	stack processing; stand alone operation or from axis2000
;
; CALLING SEQUENCE:
;	STACK_ADD, FILE
;
; INPUTS:
; 	FILE	name of the output file
;
; KEYWORDS: none
;
; OUTPUTS: 	none
;
; COMMON BLOCKS:
; AXIS_COM	standard set of common blocks
; Anal_com
; BSIF_com
; volume_data, image_stack
;
; RESTRICTIONS: none
;
; MODIFICATION HISTORY:
; (12-Nov-06 aph) first written; modified from stack_add
;-

PRO stack_append
@axis_com
@analcom
COMMON volume_data, image_stack
@bsif_com

on_error,2

fltr = '*.ncb'

file1 = pickfile2(/READ, TITLE = 'STACK 1', FILTER=fltr, /LPATH, DEFPATH=defpath)
if strlen(file1) LE 0 THEN return  ; bail-out if no filename

stack_rb, file1
stack1 = image_stack
t1 = size(image_stack)
print, 'dimensions of stack-1: ', t1
ev1=ev
filename_list1=filename_list(0:t1(3)-1)
filename_ev_msec_list1 = filename_ev_msec_list(0:t1(3)-1)

file2 = pickfile2(/READ, TITLE = 'STACK 2', FILTER=fltr, /LPATH, DEFPATH=defpath)
if strlen(file2) LE 0 THEN return  ; bail-out if no filename

stack_rb, file2
; check dimensions - if not the same, flag and abort
t2 = size(image_stack)
;print, 'dimensions of stack-2: ', t2

if t1(1) EQ t2(1) AND t1(2) EQ t2(2) then begin
	stack2 = image_stack
	ev2=ev
	help, filename_list
	filename_list2=filename_list(0:t2(3)-1)
	filename_ev_msec_list2 = filename_ev_msec_list(0:t2(3)-1)
	n_appended = t1(3)+t2(3)
	image_stack = fltarr(t1(1), t1(2), n_appended)
	ta = size(image_stack)
;	print, 'dimensions of appended stacks: ', ta
	image_stack(*,*,0:t1(3)-1)     =   stack1
	image_stack(*,*,t1(3):n_appended-1) =   stack2
; ---- append energies, filename_list and filename_ev_ms_list   -------
	ev=fltarr(n_appended)
	ev(0:t1(3)-1)=ev1
	ev(t1(3):n_appended-1)=ev2
	filename_list = strarr(n_appended)
	filename_list(0:t1(3)-1)=filename_list1
	filename_list(t1(3):n_appended-1)=filename_list2
	filename_ev_msec_list = strarr(n_appended)
	filename_ev_msec_list(0:t1(3)-1)=filename_ev_msec_list1
	filename_ev_msec_list(t1(3):n_appended-1)=filename_ev_msec_list2

; ----- write out appended stack data-----------------
	file = pickfile2(/READ, TITLE = 'Appended stack filename', FILTER=fltr, /LPATH, DEFPATH=defpath)
	if strlen(file) NE 0 then begin
		t = ax_name(file)
		filename = string(t(0)) + string(t(1)) + '.ncb'
		stack_wb, filename
	endif
endif else begin
	axis_log, 'Stacks have different dimensions.'
	ax_wait,/off		; turn off hourglass (sometimes sticks on)
	return
endelse
ax_wait,/off		; turn off hourglass (sometimes sticks on)
return
end

