; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
; Copyright (c) 1995, ALS SpectroMicroscopy Facility, er, jdd 
; ************************************* 
; 
;+ 
;FILE:  win2lpr 
; ------------------------------------- LAST CHANGED: 30-Nov-00 
;   pro WIN2LPR [, printer, SIZE=sz, XS=xs, YS=ys, SYS=sys, PR = pr, _extra=e, /LS] 
;        -- print current window 
;           defaults: printer='BL7LJ4',  SIZE=3 (inches) for ALS 
;           options: SIZE (for square windows) 
;				XS, YS = XSize, YSize (for rectangular windows) 
;				SYS = define as 'WIN' or 'X' 
;				PR = printer device ('PCL' or 'PS') 
;				/LS (landscape) 
;- 
; ----------- REVISION HISTORY ------------------------------- 
; (aph 22-Jun-97) ********  Win2LPR MODIFIED !!!! 
; (aph 28-jun-98) adapt win2lpr to print to nsls X1A spooler 
; (aph 14-apr-99) adapt win2lpr to NT use of lpr command 
; (aph 11-may-99) generalize printing using 'OTHER' 
; (30-nov-00 cgz) Migrated WIN2LPR to separate file


pro WIN2LPR, printer, SIZE=sz, XS=xs, YS=ys, SYS=sys, PR = pr, _extra=e 
;------------------------------------ 
;Defaults: printer='BL7LJ4', SIZE=3 (inches)(for ALS) 
;additional options to PRA:  /LS (landscape) 
; MODIFIED by aph, 21-jun-97 to allow printing from Windows system by 
; replacing the PRB command for WINsystems (PRB is UNIX operating system specific) 
; if SYS='WIN' and PR is not set, default printer is 'PS' (postscript) 
; 
; ----------- REVISION HISTORY ----------------------------- 
; (11-mAY-99 aph)  added PR_command keyword 
;
@axis_com
on_error, 2 
if not keyword_set(sz) then sz = 3. 
b=tvrd()                        ; get data in current DRAW window 
if keyword_set(SYS) then begin 
	if STRUPCASE(sys) EQ 'WIN' then begin 
		if not keyword_set(pr) then pr = 'PS' 
		if not keyword_set(xs) then xs = sz 
		if not keyword_set(ys) then ys = sz 
;		if pr NE 'PS' and pr NE 'PCL then pr = 'PS'  ;KLUGE! when using PR for print command 
	    SET_PLOT, pr         			;Set plotting device 
 
; Set the filename for printing from Windows to a postscript device 
		device, filename = print_file 
	   	device, /inches, xsize = xs, ysize = ys 
	   	if strupcase(pr) EQ 'PCL' then begin 
			b=congrid(b,xs*300, ys*300)	; PCL doesn't scale pixels !! 
		endif 
	   	tvscl,b 
		device,/close 
	    set_plot,'WIN' 
 
; transfer postscript file on disk to default printer or spooler 
; NB if the print device is PCL this may be a problem (11-may-99) 
; ***************** 
;	for Win-95 or Win-98 with either a local printer OR Capture Printer Port 
;			write graphic file to(def_directory)\idl.win and copy to LPT1: 
; ***************** 
;	for NSLS where there is a spooler program (WLPRSPL) 
;	  print_file = 'Spool_path'+'Local Spool file name' 
;     where these are defined in the Setup menu of the WLPRSPL spooler program 
; check  Spool directory for  			Spool_path 
; check  Queues\Edit Queue Data for   	Local Spool file name 
;		This is 'c:\tmp\X1A' in aph notebook 
; ***************** 
; FOR NT machines (no capture LPT1:)  (ALS Dow-Bl7 and Dodgson) 
; 		Use the print command as provided by user via the PR_command keyword 
;		NT has the same lpr utility as unix 
 
; GENERALIZED using Pr_Command (11-May-99) 
	if Pr_Command ne '' then begin 
		 	cmd='set_plot,''ps'' & device, bits=8' 
		 	print, cmd 
	  		print, PR_command     &  spawn, PR_command, /noshell 
	    	pcmd='del '+ print_file     			 ;delete file 
	    	print,pcmd     &  spawn,pcmd, /noshell 
	endif else begin 
; OLDER version prior to introducing Pr_Command --------------- 
		if (strlowcase(LOC) EQ 'nsls') then begin	; 	command for spooler at nsls 
			pcmd = 'WLPRSPL -L c:\program files\wlprspl\wlprspl.qs'  ; (aph 29-jun-98) 
	  		print,pcmd     &  spawn,pcmd, /noshell 
			goto,skip_copy 
		endif 
		if strlowcase(loc) EQ 'als' then begin 
		 	cmd='set_plot,''ps'' & device, bits=8' 
		 	print, cmd 
	  	  	dum=execute( cmd ) 
	;		printer_is='6-BL7LJ4M+'  ; on ALS floor 
			printer_is='7-210HP'  ; in BLDG 7 
			pcmd='lpr -S XRAYS-1 -P'+ printer_is +' ' + print_file 
	  		print,pcmd     &  spawn,pcmd, /noshell 
	    	pcmd='del '+ print_file     			 ;delete file 
	    	print,pcmd     &  spawn,pcmd, /noshell 
 
	    	set_plot,'WIN' 
		endif else begin 
		    pcmd='copy ' + print_file + ' lpt1:'   ;copy file to printer 
	;	    pcmd='print ' + print_file             ;print file to default printer 
	  		print,pcmd  &  spawn,pcmd, /noshell 
	    	pcmd='del '+ print_file     			 ;delete file 
	    	print,pcmd     &  spawn,pcmd, /noshell 
	   	endelse 
	endelse 
skip_copy: 
		dim = strcompress(string(xs)) + ' x' + strcompress(string(ys)) 
		print, 'Printed to device ', pr, '. File ',print_file,'. Xsize, Ysize ("): ', dim 
	endif 
 
endif else begin 
	pra, /inch, xsize=sz, ysize=sz, _extra=e 
	tvscl, b 
	if n_elements(printer) eq 0 then prb else prb, printer 
endelse 
end 
 
