; Copyright (c) 1998-2004 A.P. Hitchcock  All rights reserved
;+
;NAME:
;  SFConvert
;
;LAST CHANGED: ----------------------------------- 21-Jul-06
;
; PURPOSE:
;	this function calculates the OD1 spectra of a compound based on SF and OD data
;
; CATEGORY:
;	spectra Processing; stand alone operation
;
; CALLING SEQUENCE:
;	SFConvert, SAMPLE, SFData
;
; INPUTS:
; 	SAMPLE	2d array of energy and spectral data from OD of sample
;	SFData 2D array of spectral data
;
; KEYWORDS: none
;
; OUTPUTS: 	none
;
; COMMON BLOCKS: none
;
;
; RESTRICTIONS: none
;
; MODIFICATION HISTORY:
; (21-Jul-06 jso) first version

Function SFConvert, Sample=Sample, SFdata = SFdata

	SFUse=genextrap(En = Sample[0,*], Data=SFdata)
	;Takes SF data and puts it into same energy scale as Sample data

	;Float arrays for regression are assembled
	QarrX = fltarr(1,15)
	QarrY = fltarr(1,15)

	QarrX[0:9] = Sample(1,0:9)
	QarrY[0:9] = SFuse(0:9)
	QarrX[10:14] = Sample(1, length(sample)-5:length(sample)-1)
	QarrY[10:14] = SFuse(length(SFuse)-5:length(SFuse)-1)

	result = POLY_FIT(QarrX,QarrY,1)
	Slope = Result[1]
	Const = Result[0]

	ans = sample[1,*] * Slope + Const

;return od1 data
return, ans
end