; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
 
; ************************** AXIS.PRO *********************************** 
; start-up file for AXIS 
; IDL widget for Analysis of X-ray microscopy Image and Spectral data 
; @Hitchcock Enterprises unlimited 
; ******************************************* AXIS 2000 (2.0b) 
; 
; ======================================= LAST CHANGED: (cgz 30-nov-00) 
; 
; AXIS.PRO is a batch file used to load routines needed by the AXIS widget 
; Each file contains one or more PRO's and FUNCTION's which are loaded 
; into memory from one specific location to avoid incompatible code 
; 
; Since Dec-98, based on IDL 5.2; 
; NB IDL 4.0 does not work  for versions after AXIS 1.7 
; 
; ------------ Development History ----------------------------- 
; ( Aug-97 aph) first used when merged spectral & image 
; ( Mar-98 aph) added extend path - needed for UNIX systems 
; (13-Jun-98 aph) incorporated stack pros in start-up 
; (14-jun-98 aph) adapted all {*.pro} to use @--_com includes (not e.g. axis_com.mon) 
; (18-jun-98 aph) 1.4d code changes implemented (plotbuf, sav_hdf, sav_hdfm) 
;                   due to incompatibility with Linux 5.03 version of IDL 
; ( 7-jul-98 aph) new pro files (ln_algn, axis_ini); initialization file in call 
; (29-Dec-98 aph) incorporate new files for version 1.6; convert to aaa_axis.pro 
; (03-jan-99 aph) incorporate new files for version 1.6 
; (11-jan-99 aph) use corrected version of XLOADCT (com error) = ALOADCT 
; (18-jan-99 aph) add ln_load to compile; remove read_re 
; (13-mar-99 aph) adapt to WIN-NT system at ALS 
; (25-mar-99 aph) update for code changes for 1.6b 
; ( 7-jun-99 aph) names consistent with IDL 4 (8.3) 
; (15-jun-99 aph) more new stuff ! 
; (25-jun-99 aph) adapt for Zimba_stack; axis_color 
; ( 9-jul-99 aph) add Refresh 
; (12-aug-99 aph) add ax_svd; finalise 1.7 
; (15-sep-99 aph) added routines for nsls cryo-stxm images 
; (19-sep-99 aph) added ax_wait 
; (25-sep-99 aph) put in zstack_color (full version - Jul99 of zimba; but color low) 
; (26-sep-99 aph) change to axis_on; introduce axis_start widget 
; 				use FULL names (matched to file name) as far as possible 
; (28-sep-99 aph) added AX_COPY, AX_SWITCH 
; ( 3-oct-99 aph) added AX_PARTICLES 
; (14-oct-99 aph) ax_start, ax_sep 
; (17-oct-99 aph) read_cryp, axis_read_image 
; (12-nov-99 aph) ax_pc, ax_colorbar, colorbar 
; (16-nov-99 aph) ax_zoom_cut, resetplots 
; (23-nov-99 aph) line_fit 
; (30-dec-99 aph) mods for version 2.0 
;	added: 	rotate, ax_prof_rad, ax_zoom_cursor, ax_image_add, ax_img_avg 
; 			ax_img_del, ax_nc2gif, ax_spec_delete, deglitch, clip 
; (31-jan-00 aph) added ax_logo_load,ax_write_xas, ax_read_xas, read_xas 
; (27-feb-00 aph) aXis2000 documentation; noted dependence of gen_read.pro on rdstrbig.pro 
; (15-apr-00 aph) add stack_make; plot2d; remove graph 
; (20-may-00 aph) add ncdf2als 
; (29-jun-00 aph) add ax_image_append 
; (11-Sep-00 aph) add ax_fix_rollover 
;+ 
;NAME: 
;	AXIS 
; 
;LAST CHANGED: -----------------------------------  30-nov-00 
; 
;PURPOSE: 
;	This procedure compiles all files used by the AXIS widget. 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE:  @axis (at the IDL prompt) 
; 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: starts execution of AXIS 
; 
;COMMON BLOCKS: none 
; 
; PROCEDURE 
;	The AXIS batch file is used to start AXIS in order to 
; ensure the  subdirectory from which AXIS is being run 
; contains a complete set of pro files. In principle the IDL auto load 
; or the RESOLVE_ALL routine could be used to achieve this. 
; However, a number of the utility and event call back pro files 
; contain multiple routines that are not visible to RESOLVE_ALL. 
; The working AXIS code directory can be set from the Utilities->Set preferences 
; command in AXIS. The default is C:\axis on WIN machines. 
; IDL library files are loaded as needed 
; 
;MODIFICATION HISTORY: 
; (02-jan-00 aph) AXIS standard documentation. See file for more 
;- 
 
 
; ********************   SET STARTING DIRECTORY ********************************* 
; MODIFY the next command to set the default directory to the one with AXIS code 
; ALSO . . . change the corresponding line in the file RESTART.PRO 
; NB when the default directory is changed and axis is then restarted 
; by executing axis_c there is an error (can't find the logo file AXIS.BMP) which 
; the @recover procedure does not correct. In this case, execute RESTART. 
; This will kill the damaged AXIS widget; change to the axis source directory and run axis_c. 
; ********************************************************************************************* 
; ********************     ; CHANGE THIS LINE TO SWITCH Default IDL Path to   ***************** 
cd, 'c:\axis'              ; LOCATION WHERE AXIS code resides         ***************** 
; ********************     ; see also end of this file for a related change   ***************** 
; ********************************************************************************************* 
; NOTE about PATHS: 
; a subdirectory containing PRO files that AXIS requires can be appended to the existing 
; PATH that IDL is using by executing the command: 
;              !path = !path + EXPAND_PATH('NEW_directory') 
; IF you wish to have IDL search ALL DIRECTORIES contained within a given directory: 
;              !path = !path + EXPAND_PATH('+NEW_directory') 
; on Windows systems: the PATH searched by IDL to find PRO filescan modified in the 
;                     "Preferences" command in the File pull-down menu 
; on UNIX systems:   the PATH must be controlled by using EXPAND_PATH in this start-up file. 
; 
;!path=!path+':'+expand_path('+/data/stxm/axis')  ; include axisdir and subdirectories in path (UNIX) 
; 
; ******************** 
; adapted from als (jdd) 
; ******************** 
; NB ******** sequence of loading is critical ******* 
;  - therefore this alphabetized list is for documentation ONLY 
; 
; .run file 
; .run gen_read 
; .run graph		; retired 15-apr-00 
; .run io 
; .run math 
; .run misc 
; .run pick2 
; .run print 
; .run read_a_n 
; .run read_abs 
; .run read_als 
; .run read_xas 
; .run splota 
; .run readstringbig 
; .run spectra 
; .run srotate 
; .run struct 
; .run window 
 
T = systime(1)

; common stuff (BSIF format) needed for nsls and some conversion 
@axis_com
@bsif_com

;.run math			; retired 15-nov-00 cgz
.run interp
				; interp newly defined from math.pro
.run interspline
				; interspline newly defined from math.pro
;.run file			; retired 11-nov-00 cgz
.run parsestring
				; parsestring newly defined from file.pro
.run chkfileblocks
				; chkfileblocks newly defined from file.pro
.run text_read
				; text_read newly defined from file.pro
.run text_read1
				; text_read1 newly defined from file.pro
;.run structure		; retired 11-nov-00 cgz
.run stag
				; stag newly defined from structure.pro
.run copy_bytes
;.run io			; retired 11-nov-00 cgz
.run read_img
				; read_img newly defined from io.pro
;.run misc			; retired 14-nov-00 cgz
;.run graph		; retired 15-apr-00 aph
;.run window		; retired 04-dec-00 cgz
;.run print		; retired 29-nov-00 cgz
;.run splota		; retired 14-nov-00 cgz
.run splot
				; splot newly defined from splota.pro
.run splot2d
				; splot2d newly defined from splota.pro
.run splot3d
				; splot3d newly defined from splota.pro
.run read_als
.run read_a_n
.run readstringbig
.run read_untilstring
.run read_until_nochar
.run read_numbers
.run parsebytes
				; modified 15-nov-00 cgz
.run gen_read
.run spectra
.run srotate

; ********************
; developed for AXIS package (aph)
; ********************
; basic functions used in later pro's
.run dindex
;@bsif_com

; Fanning code for colorbar
.run colorbar
.run ax_colorbar
;.run ax_colorbar_zimba

; tools
.run align
.run als2ncdf
.run als_specin
.run als_spectra
.run als_spectra_eventcb
.run ax_bin
.run ax_clear
;.run ax_clear_zimba
.run ax_color
;.run ax_color_zimba
.run ax_conv
.run ax_copy
.run ax_fix_rollover
.run ax_image_add
.run ax_image_append
.run ax_img_avg
.run ax_img_del
.run ax_imscl
.run ax_interp
.run ax_load_logo
;.run ax_load_logo_zimba
.run ax_mesh
.run ax_name
;.run ax_name_zimba
.run ax_nc2gif
.run ax_order
.run ax_particles
;.run ax_particles_zimba
.run ax_pc
.run ax_prof_rad
.run ax_read_xas
.run ax_rd_im
.run ax_sep
.run ax_spec_delete
.run ax_svd
.run ax_switch
.run ax_wait
.run ax_write_xas
.run ax_xycal
.run ax_xydis
.run ax_xyscl
.run ax_zoom_cursor
.run ax_zoom_cut
.run ax_zoom_pan
.run axb_load
.run axb_save
.run axis_add
.run axis_app
.run axis_ini
;.run axis_ini_zimba
.run axis_options
;.run axis_options_zimba
.run axis_options_eventcb
;.run axis_options_eventcb_zimba
.run axis_read_image
.run axis_web
.run bnl_load
.run buffer
.run box
.run bx_cursor
.run clean
.run clip
.run copy_bytes
.run cryo_to_stxm
.run deglitch
.run disp3col
.run edgegauss
.run file_overwrite
.run file2string
.run get_num
.run get_path
.run get_text
.run img_algn
.run img_asav
.run img_load
.run img_warp
.run info
.run init_sd
.run init_stxm_sd
.run join_string
.run line_fit
.run lineclear
.run ln_add
.run ln_align
.run ln_load
.run ln_locat
.run ln_norm
.run ln_subsp
.run load_nex
.run load_spm
;.run loadspem
				; 15-nov-00 retired cgz
.run make_square
.run mbuf
.run ncdf2als
.run pem_load
.run pickfile2
.run plot2d
.run plotbuf
.run plotsect
.run rd_peem
.run rd_spem
.run read_a_n
.run read_als
.run read_axm
.run read_bnl
.run read_bsp
.run read_cryo
.run read_csv
.run read_mapper
.run read_mef
.run read_phi
.run read_stxm
.run read_sxm
.run read_tof
.run read_xas
.run refresh
.run resetplots
.run sav_als
.run sav_hdf
.run sav_hdfm
.run setgraf
.run sav_nsls
.run spc_load
.run spc_save
.run split_string
.run srotate
.run stack_align
.run stack_analyze
.run stack_buildlist
.run stack_fit
.run stack_list
.run stack_make
.run stack_movie
.run stack_plot_spectrum
.run stack_rb
.run stack_readlist
.run stack_wb
.run stack_writelist
.run str_columns
.run string2file
.run sxm_fileexists
.run sxm_ipar
.run sxm_readfile
.run sxm_strclean
.run thumblbls
.run thumbzoom
.run tif_load
.run tif2ncdf
.run tifrd_im
.run tri_fit
.run tweak
.run write_ncdf
.run write_spectrum
.run write_xas
.run write_stxm
.run wrstx_ax
.run wt_spec
.run xas1
.run xas2

; ********************
; stuff for Z_stacks (Zimba files)
; ********************
.run box_cursor
;.run zimba_run
.run zstack_analyze
; NB zstack_color must come before zstack_color
.run zstack_color
.run zstack_buildlist
.run zstack_readlist
.run zstack_align_images
.run zstack_shift
.run zstack_tune
.run zstack_align
.run zstack_save
.run zstack_profile
.run zstack_spectra

; ********************
; stuff to load SF (Henke calculator for X-ray absorption parameters)
; ********************
;.run photon_conv		; retired 14-nov-00 cgz
.run wvlen2en
				; wvlen2en newly defined from photon_conv.pro
.run en2wvlen
				; en2wvlen newly defined from photon_conv.pro
.run string2file
.run uniq
.run sf

;.run axis_dialog
;.run axis_c_zimba
;.run axis_zimba

print,string((systime(1) - T))+' seconds'

; ********************* 
; RESOLVE_ALL 
; **************** for the bold - should ensure all code present 
 
; ******************** 
; run the main code 
; MODIFY the start_file name to the one which you use for your system 
; defualt s no rotation. 
; use the /rotate keyword to activate the rotating logo 
; ******************** 
axis_c, start_file = 'axis.ini'  ;, /rotate 
