; Copyright (c) 1998-2009  A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_DIALOG
;
;LAST CHANGED: ----------------------------------- 01-Feb-09 (aph)
;
;PURPOSE:
;	This procedure creates the widget for use with aXis2000
;
;CATEGORY:
;	AXIS: data analysis
;
;CALLING SEQUENCE:
;	AXIS_DIALOG
;
;INPUTS:  NONE
;
;KEYWORDS:  NONE
;
;OUTPUTS: NONE
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (10-mar-00 cgz) initially written
; (30-mar-00 cgz) modifications to acommadate changes by APH in AXIS
; (30-may-00 cgz) modifications to acommadate changes by APH in AXIS
; (09-dec-00 cgz) reconciliation with AXIS v.2.0.b
; (29-dec-00 aph) remove SVD-map from images menu; change Zoom; thumbnails submenus
; (04-jan-01 cgz) created menu button bar for most frequently accessed simple functions
;			modified lineout options for reduced screen use, i.e., laptops
; (22-jan01 cgz) reduced space gap between row of pull down menus and buttons
; (05-feb-01 aph) extend images~average pixels_all; utilities~change mesh re-introduced
; (11-feb-01 aph) add read_bl5 menu items
; (13-feb-01 aph) add spectra~curve fit
; (21-feb-01 aph) add ALS XM-1 image read-in
; (17-apr-01 aph) update identifier to reflect changes
; (07-jun-01 aph) introduce ALS PEEM widget - not functional as of 26-jun-01
; (27-jun-01 aph) read_stxm4 nsls image read in
; (12-jul-01 aph) convert stxmIV for stack read-in
; (27-jul-01 aph) add CGO procedure for stack mapping
; (12-aug-01 aph) add widget for PEEM tif to netCDF conversion
; (29-aug-01 aph) add 5.3.2 stack read in
; (30-sep-01 aph) add Read~spectra~nsls~stxmIV
; (07-oct-01 aph) colorbar fills sub-wiget; rearrangement of panel (gamma to bottom; etc)
; (14-oct-01 aph) SPECTRA: add additional processing
; (28-oct-01 aph) add WRITE_SDF
; (26-nov-01 aph) re-order
; (19-dec-01 aph) version increment
; (28-dec-01 aph) add image~replace_line (to fix up early 5.3.2 errors); frontpanel
; (31-dec-01 aph) add utilities~Execute macro; add PNG write and read
; (16-feb-02 aph) add utilities~scale bar
; (30-mar-02 aph) move overplot command to main line menu
; (17-apr-02 aph) add Elmitecx readin
; (28-apr-02 aph) adapt Elmitec read-in to *.dat (binary format)
; (08-may-02 aph) introduce sphinx stack read-in (adapted ALS PEEM)
; (12-may-02 aph) modify display comand order; delete read~stxm532_early
; (16-jul-02 aph) VERSION J started ;  elmitec peem read-in
; (28-jul-02 aph) clean up log entries on aXis2000 start-up
; (06-aug-02 aph) add Andy Smith's tif_convert for ALS (&SRC) PEEM data
; (09-sep-02 aph) add ax_one_pt
; (30-oct-02 aph) add sphinx-spectra
; (15-feb-03 aph) add multi-column spectral read-in
; (12-mar-03 aph) version identifier set to 2.1m  for release
; (02-jun-03 aph) improve PEEM data conversion
; (18-jun-03 aph) update banner : stack_analyze & stack_fit improvements
; (20-sep-03 aph) add absolute value to spectral processing; multiply buffers
; (15-nov-03 aph) histogram
; (30-dec-03 aph) redfine version (force monotonic in fitting introduced)
; (14-feb-04 aph) add read_all for TOF
; (20-feb-04 aph) add stacks~convert~TOF-all
; (10-Apr-04 aph) add image~remove_zeros
; (02-may-04 aph) update to 2.1p
; (17-may-04 aph) add Lox read-in
; (09-jun-04 aph) update version to 2.1q
; (28-aug-04 aph) update version to 2.1p
; (14-sep-04 aph) add image~average~whole~non-zero function
; (17-0ct-04 aph) add stack_add; change STXM_5.3.2 to ALS_STXM
; (28-Oct-04 aph) change order of stack analysis widgets
; (20-nov-04 aph) generalize binning of images, files
; (21-jun-05 aph) update version
; (03-feb-05 aph) add REGRESS based curve fits
; (20-feb-05 aph) fixed Ax_regress plotting; ALS_STXM map; re-order stacks menu
; (21-mar-05 aph) add utilities~write axis ascii
; (25-mar-05 aph) revise dialog to remove unused buttons
; (28-may-05 aph) revise for correction to PEM_load.pro etc
; (14-Jun-05 aph) fixed non-monotonic (I hope!); improve tif_convert; fix oplot 1-point sections of non-monotonic spectra
; (17-Jun-05 aph) various updates (ALS_STXM, map, 1-image with regions; etc)
; (20-jul-05 aph) update version (stack analyze color problem fixed
; (08-aug-05 aph) add write~litho; remove Sphinx_nc
; (18-sep-05 aph) add reset-color, display~RGB image
; (18-oct-05 aph) add read_lox
; (03-nov-05 aph) add read_xyt and procedure to mask patterns for integration
; (13-nov-05 aph) update tag line
; (14-dec-05 aph) add stacks~tomography~convert
; (28-jan-06 aph) add read~images~roi
; (04-Feb-06 aph) update version identified and some menu labels
; (09-feb-06 aph) read PEEM2 AOIs added
; (16-feb-06 aph) update colors; layout; fix slider (removed /drag)
; (23-feb-06 aph) add access to slicer3; re-arrange read~image to simplify
; (05-mar-06 aph) fix img_warp
; (22-mar-06 aph) fix channel selection in Lox read-inn; normalize to 400 mA (STXM-sdf)
; (15-Apr-06 aph) add convert to BE
; (21-apr-06 aph) improve stack_analyze (auto zoom, roi)
; (26-apr-06 aph) read jpg images (1); convert sequence of jpg images
; (01-may-06 gaj) add convert NCB to MRC
; (04-may-06 aph) polarization fit to polarization signals and stacks
; (31-may-06 aph) remove /scroll on initial definition of base; reformat right side a bit
; (10-jun-06 aph) add routine to convert set of SDF images into a stack; JSO adaptation of stack_analyse
; (12-jun-06 aph) add images~roi~lox
; (12-jun-06 gaj) add stacks~convert format~mrc to ncb
; (21-jul-06 jso) added spectra~convert_to_OD1
; (01-Aug-06 gaj) add stacks~convert format~ncb to mpg for making movies
; (13-aug-06 aph) integrate GAJ and JSO changes
; (22-sep-06 aph) re-arrange stack~convert menu; fix line_fit  (B. Watts bug finder)
;                 incorporate Remy Coulombe's region analysis for PEEM
; (06-oct-06 aph) Remy's region, stack_analyze & axis_dialog update
; (12-Nov-06 aph) add stacks~append, generate_mask~manual
; (04-Dec-06 aph) use scroll bar only for windows operating systems
; (20-Jan-07 aph) add read-in for ALS PEEM3 format images, spectra and stacks
; (11-mar-07 aph) update version
; (01-jun-07 aph) add link to PCA_GUI, update version
; (14-jul-07 aph) add stacks~tomography~axb
; (13-Sep-07 aph) update version
; (10-Dec-07 aph) add bin Lox stacks
; (29-Dec-07 aph) add  stack~ax_rgb_widget; stack~transmission
; (01-Feb-08 aph) convert_to_OD fixed and menu changed
; (21-Mar-08 aph) update version
; (20-Apr-08 aph) update version
; (04-Jun-08 aph) update version; change XAS spectrum to multi-col
; (15-Jun-08 aph) update version
; (17-sep-08 aph) add in CJJ stack_analyze
; (11-oct-08 aph) add read Bessy stxm images
; (26-Dec-08 aph) start Read~stacks menu item; add read_ftir (IR maps from Nicolet / soleil)
; (12-Jan-09 aph) add stack~differentiate menu item
; (1-FEb-09 aph) update date of package
;-
PRO axis_dialog

@axis_com
@ax_peem_com

  IF N_ELEMENTS(Group) EQ 0 THEN GROUP=0
  junk   = { CW_PDMENU_S, flags:0, name:'' }

;-----------------------------------			; **********************************
; Diplay & print version identifier            	; **********************************
	axis_ver ='01-Feb-09' 		                ; *****  VERSION IDENTIFIER ********
	print, ' '									; **********************************
;-----------------------------------			; **********************************

; ----------- document version identifier in the log window ---
;
print, '---------------------------------------------------------------------------'
print, 'AXIS2000 ver ',axis_ver
print, 'Started on ', systime()
print, '---------------------------------------------------------------------------'
print, ' '

; set font to DEVICE specific value set in AXIS.INI file
;  widget_control, Default_Font = BufLblFont
; removed by CGZ since this causes numerous problems in non-axis dialogs

; Create pull down menus

Axis_Menu_List = [ $	;Axis_Menu_List,  $
	; READ Input
	{ CW_PDMENU_S,       1, 'Read' }, $
		{ CW_PDMENU_S,			0, 'STXM (sdf)' }, $
		{ CW_PDMENU_S,			0, 'PEEM (lox)' }, $
		; STACK Input
		{ CW_PDMENU_S,			1, 'Stacks' }, $
				{ CW_PDMENU_S,		0, 'FTIR' }, $
				{ CW_PDMENU_S,		2, 'PEEM' }, $
		; IMAGE Input
		{ CW_PDMENU_S,			1, 'Images' }, $
			{ CW_PDMENU_S,			0, 'AXIS' }, $
;				{ CW_PDMENU_S,			0, 'ascii' }, $
;				{ CW_PDMENU_S,			2, 'binary' }, $
			{ CW_PDMENU_S,			0, 'ALS-xyt' }, $
			{ CW_PDMENU_S,			1, 'Bessy' }, $
				{ CW_PDMENU_S,			0, 'image' }, $
				{ CW_PDMENU_S,			2, 'stack' }, $
			{ CW_PDMENU_S,			1, 'Graphics' }, $
				{ CW_PDMENU_S,			1, 'BMP' }, $
					{ CW_PDMENU_S,			0, 'image' }, $
					{ CW_PDMENU_S,			2, 'data' }, $
				{ CW_PDMENU_S,			1, 'GIF' }, $
					{ CW_PDMENU_S,			0, 'image' }, $
					{ CW_PDMENU_S,			2, 'data' }, $
				{ CW_PDMENU_S,			1, 'JPG' }, $
					{ CW_PDMENU_S,			0, 'image' }, $
					{ CW_PDMENU_S,			2, 'data' }, $
				{ CW_PDMENU_S,			1, 'PNG' }, $
					{ CW_PDMENU_S,			0, 'image' }, $
					{ CW_PDMENU_S,			2, 'data' }, $
				{ CW_PDMENU_S,			3, 'TIF' }, $
					{ CW_PDMENU_S,			0, 'image' }, $
				{ CW_PDMENU_S,				2, 'data' }, $
			{ CW_PDMENU_S,			1, 'NSLS' }, $
				{ CW_PDMENU_S,			0, 'old (*.nc)' }, $
				{ CW_PDMENU_S,			0, 'stxmIV' }, $
				{ CW_PDMENU_S,			2, 'cryo' }, $
			{ CW_PDMENU_S,			1, 'PEEM' }, $
				{ CW_PDMENU_S,			0, 'ALS-PEEM2' }, $
				{ CW_PDMENU_S,			0, 'ALS-PEEM3' }, $
				{ CW_PDMENU_S,			1, 'Elmitec' }, $
					{ CW_PDMENU_S,			0, 'dat' }, $
					{ CW_PDMENU_S,			2, 'tif' }, $
				{ CW_PDMENU_S,			0, 'Lox-PEEM' }, $
				{ CW_PDMENU_S,			2, 'Mephisto' }, $
			{ CW_PDMENU_S,			1, 'ROI' }, $
				{ CW_PDMENU_S,			0, 'lox' }, $
				{ CW_PDMENU_S,			0, 'peem2' }, $
				{ CW_PDMENU_S,			2, 'aXis2000 stack' }, $
			{ CW_PDMENU_S,			1, 'TOF' }, $
				{ CW_PDMENU_S,			0, 'all (pTA)' }, $
				{ CW_PDMENU_S,			2, 'img' }, $
			{ CW_PDMENU_S,			3, 'Other' }, $
				{ CW_PDMENU_S,			0, 'ALS-SPEM' }, $
				{ CW_PDMENU_S,			0, 'ALS-STXM-7.0' }, $
				{ CW_PDMENU_S,			0, 'ALS-STXM-7.0.linescan' }, $
				{ CW_PDMENU_S,			2, 'ALS-XM1' }, $

		; SPECTRAL Input
		{ CW_PDMENU_S,			1, 'Spectra' }, $
			{ CW_PDMENU_S,			0, 'AXIS' }, $
			{ CW_PDMENU_S,			0, 'multi-column' }, $
			{ CW_PDMENU_S,			0, 'ALS-STXM-7.0' }, $
			{ CW_PDMENU_S,			1, 'ALS-SPEM' }, $
				{ CW_PDMENU_S,			 0, 'XPS' }, $
				{ CW_PDMENU_S,			2, 'NEXAFS' }, $
			{ CW_PDMENU_S,			0, 'ALS-PEEM' }, $
			{ CW_PDMENU_S,			0, 'Lox-PEEM' }, $
			{ CW_PDMENU_S,			1, 'NSLS' }, $
				{ CW_PDMENU_S,			0, 'nc' }, $
				{ CW_PDMENU_S,			0, 'stxmIV' }, $
				{ CW_PDMENU_S,			0, 'ascii' }, $
				{ CW_PDMENU_S,			2, 'map' }, $
			{ CW_PDMENU_S,			1, 'SPHINX-PEEM' }, $
				{ CW_PDMENU_S,			0, '1' }, $
				{ CW_PDMENU_S,			2, 'all' }, $
			{ CW_PDMENU_S,			2, 'XAS' }, $
;			{ CW_PDMENU_S,		0, 'ALS-STXM-5.3.2-early' }, $
			{ CW_PDMENU_S,			2, '' }$
]	; End of READ Input

Axis_Menu_List = [Axis_Menu_List, $
	; WRITE Output
	{ CW_PDMENU_S,			1, 'Write' }, $
		{ CW_PDMENU_S,			0, 'AXIS' }, $
		{ CW_PDMENU_S,			1, 'GIF' }, $
			{ CW_PDMENU_S,			0, 'image' }, $
			{ CW_PDMENU_S,			2, 'data' }, $
		{ CW_PDMENU_S,			1, 'JPG' }, $
			{ CW_PDMENU_S,			0, 'image' }, $
			{ CW_PDMENU_S,			2, 'data' }, $
		{ CW_PDMENU_S,			1, 'PNG' }, $
			{ CW_PDMENU_S,			0, 'image' }, $
			{ CW_PDMENU_S,			2, 'data' }, $
		{ CW_PDMENU_S,			1, 'TIF' }, $
			{ CW_PDMENU_S,			0, 'image' }, $
			{ CW_PDMENU_S,			2, 'data' }, $
		{ CW_PDMENU_S,			0, 'ALS-image' }, $
		{ CW_PDMENU_S,			0, 'ALS-xyt' }, $
		{ CW_PDMENU_S,			0, 'NSLS-image (*.nc)' }, $
		{ CW_PDMENU_S,			0, 'SDF (5.3.2) format' }, $
		{ CW_PDMENU_S,			2, 'XAS single/multiple' } $
]	; End of WRITE Output

Axis_Menu_List = [Axis_Menu_List, $
	; Zoom
	{ CW_PDMENU_S,			1, 'Zoom' }, $
		{ CW_PDMENU_S,			1, 'Image' }, $
			{ CW_PDMENU_S,			0, 'Pan' }, $
			{ CW_PDMENU_S,			0, 'Cursor - cut' }, $
			{ CW_PDMENU_S,			2, 'Numerical - cut' }, $
		{ CW_PDMENU_S,			3, 'Spectra' }, $
			{ CW_PDMENU_S,			0, 'Cursor' }, $
			{ CW_PDMENU_S,			0, 'Normal' }, $
			{ CW_PDMENU_S,			0, 'Out x 2' }, $
			{ CW_PDMENU_S,			2, 'Numerical' } $
]	; End of ZOOM

Axis_Menu_List = [Axis_Menu_List, $
	; FILTER (both)
	{ CW_PDMENU_S,			1, 'Filter' }, $
		{ CW_PDMENU_S,			0, 'Smooth' }, $
		{ CW_PDMENU_S,			0, 'Median' }, $
		{ CW_PDMENU_S,			0, 'Lee Filter' }, $
		{ CW_PDMENU_S,			0, 'Convol' }, $
		{ CW_PDMENU_S,			2, 'Clean (FT image filter)' } $
]	; End of FILTER

Axis_Menu_List = [Axis_Menu_List, $
	; IMAGE Process
	{ CW_PDMENU_S,			1, 'Images' }, $
		{ CW_PDMENU_S,			1, 'Add' }, $
		  { CW_PDMENU_S,			0, 'Append' } , $
			{ CW_PDMENU_S,			0, 'Buffer' }, $
			{ CW_PDMENU_S,			2, 'Constant' }, $
		{ CW_PDMENU_S,			1, 'Average pixels' }, $
			{ CW_PDMENU_S,			0, 'whole image - all pixels' }, $
			{ CW_PDMENU_S,			0, 'whole image - ignore zeros' }, $
			{ CW_PDMENU_S,			0, 'region - all pixels' }, $
			{ CW_PDMENU_S,			2, 'region - ignore zeros' }, $
		{ CW_PDMENU_S,			0, 'bin' }, $
		{ CW_PDMENU_S,			1, 'Calibrate XY' }, $
			{ CW_PDMENU_S,			0, '1 point' }, $
			{ CW_PDMENU_S,			2, '2 points' }, $
		{ CW_PDMENU_S,			0, 'Clip signal' }, $
		{ CW_PDMENU_S,			0, 'Convert_to_OD' }, $
		{ CW_PDMENU_S,			0, 'Cross-link density' } , $
		{ CW_PDMENU_S,			0, 'Deglitch' }, $
		{ CW_PDMENU_S,			0, 'Delete region' }, $
		{ CW_PDMENU_S,			0, 'Distort XY scale' }, $
		{ CW_PDMENU_S,			0, 'exp(Z)' }, $
		{ CW_PDMENU_S,			1, 'Fix rollover' } , $
			{ CW_PDMENU_S,			0, '1' } , $
			{ CW_PDMENU_S,			2, 'many' } , $
		{ CW_PDMENU_S,			1, 'Gain' } , $
			{ CW_PDMENU_S,			0, 'Multiply' } , $
			{ CW_PDMENU_S,			2, 'Divide' } , $
		{ CW_PDMENU_S,			1, 'generate mask' }, $
			{ CW_PDMENU_S,			0, 'threshold' } , $
			{ CW_PDMENU_S,			2, 'manual' } , $
		{ CW_PDMENU_S,			0, 'histogram' }, $
		{ CW_PDMENU_S,			0, 'ln(Z)' }, $
		{ CW_PDMENU_S,			0, 'log10(Z)' }, $
		{ CW_PDMENU_S,			0, 'Modify one point' }, $
		{ CW_PDMENU_S,			0, 'Multiply buffers' }, $
		{ CW_PDMENU_S,			0, 'Particle analyze' }, $
		{ CW_PDMENU_S,			1, 'Profiles' }, $
			{ CW_PDMENU_S,			0, 'Linear' }, $
			{ CW_PDMENU_S,			2, 'Radial' }, $
		{ CW_PDMENU_S,			0, 'Ratio to' }, $
		{ CW_PDMENU_S,			0, 'Remove zeros' }, $
		{ CW_PDMENU_S,			0, 'Replace line' }, $
		{ CW_PDMENU_S,			0, 'Resize' } , $
;		{ CW_PDMENU_S,			0, 'RGB composite' }, $
		{ CW_PDMENU_S,			0, 'Rotate' }, $
		{ CW_PDMENU_S,			0, 'Set XY scale' }, $
		{ CW_PDMENU_S,			2, 'Warp' } $
]	; End of IMAGE Process

Axis_Menu_List = [Axis_Menu_List, $
	; STACK process
	{ CW_PDMENU_S,			1, 'Stacks' }, $
		{ CW_PDMENU_S,			1, 'Analyze' }, $
			{ CW_PDMENU_S, 			0, 'AXIS binary'}, $
			{ CW_PDMENU_S,			0, 'AXIS' }, $
			{ CW_PDMENU_S,			0, 'Jacobsen' }, $
;			{ CW_PDMENU_S,			0, 'Remy Coulombe' }, $
			{ CW_PDMENU_S,			2, 'Zimba'}, $
  	  { CW_PDMENU_S,			0, 'Add' }, $
  	  { CW_PDMENU_S,			0, 'Append' }, $
		{ CW_PDMENU_S,			1, 'bin' }, $
			{ CW_PDMENU_S,			0, 'current image' }, $
			{ CW_PDMENU_S,			1, 'NSLS' }, $
				{ CW_PDMENU_S,			0, '1' }, $
				{ CW_PDMENU_S,			2, 'file' }, $
			{ CW_PDMENU_S,			3, 'stack' }, $
				{ CW_PDMENU_S,			0,  '*.ncb' }, $
				{ CW_PDMENU_S,			2, 'lox' }, $
		{ CW_PDMENU_S,			1, 'convert format' }, $
			{ CW_PDMENU_S,			0, 'OD to transmission' }, $
			{ CW_PDMENU_S,			1, 'ALS to netCDF' }, $
				{ CW_PDMENU_S,			0, '1' }, $
				{ CW_PDMENU_S,			0, 'many' }, $
				{ CW_PDMENU_S,			2, 'file' }, $
			{ CW_PDMENU_S,			1, 'to axis binary from' }, $
				{ CW_PDMENU_S,			0, 'bmp' }, $
				{ CW_PDMENU_S,			0, 'jpg' }, $
				{ CW_PDMENU_S,			0, 'mrc' }, $
				{ CW_PDMENU_S,			0, 'NSLS STXMIV' }, $
				{ CW_PDMENU_S,			2, 'TOF-all' }, $
			{ CW_PDMENU_S,			1, 'from axis binary to' }, $
				{ CW_PDMENU_S,			0,	'mrc' }, $
				{ CW_PDMENU_S,			2,	'mpg' }, $
			{ CW_PDMENU_S,			1, 'netCDF to ALS' } , $
				{ CW_PDMENU_S,			0, '1' } , $
				{ CW_PDMENU_S,			2, 'file' } , $
				{ CW_PDMENU_S,		0, 'PEEM' }, $
				{ CW_PDMENU_S,		1, 'PEEM-old' }, $
				{ CW_PDMENU_S,			1, 'ALS-PEEM' }, $
					{ CW_PDMENU_S,			0, 'to *.ncb' }, $
					{ CW_PDMENU_S,			2, 'to netCDF' }, $
				{ CW_PDMENU_S,			2, 'SPHINX' }, $
			{ CW_PDMENU_S,			0, 'NSLS-STXMIV to netCDF' }, $
			{ CW_PDMENU_S,			0, 'NSLS to GIF' }, $
			{ CW_PDMENU_S,			3, 'NSLS to HDF' }, $
				{ CW_PDMENU_S,			0, '1' }, $
				{ CW_PDMENU_S,			2, 'many' }, $
		{ CW_PDMENU_S,			0, 'Differentiate' },  $
		{ CW_PDMENU_S,			0, 'Generate_stack' },  $
		{ CW_PDMENU_S,			1, 'Image alignment' }, $
			{ CW_PDMENU_S,			0, 'shift' }, $
			{ CW_PDMENU_S,			0, 'stretch/shift' }, $
			{ CW_PDMENU_S,			2, 'warp' } , $
		{ CW_PDMENU_S,			1, 'maps' }, $
			{ CW_PDMENU_S,			0, 'SVD' }, $
			{ CW_PDMENU_S,			0, 'Stack fit' }, $
			{ CW_PDMENU_S,			0, 'CGO curve fit' }, $
			{ CW_PDMENU_S,			2, 'polarization fit' }, $
		{ CW_PDMENU_S,			0, 'RGB - color composite map' },  $
		{ CW_PDMENU_S,			0, 'Slicer (3d viewer)' }, $
		{ CW_PDMENU_S,			0, 'Stack_movie' }, $
		{ CW_PDMENU_S,			1, 'Statistical analysis' }, $
			{ CW_PDMENU_S,			0, 'principle components' }, $
			{ CW_PDMENU_S,			2, 'PCA_GUI (CJJ Dec 2005)' }, $
		{ CW_PDMENU_S,			3, 'Tomography' }, $
			{ CW_PDMENU_S,			0, 'gen_stack from SDF files' }, $
			{ CW_PDMENU_S,			0, 'read one image' }, $
			{ CW_PDMENU_S,			0, 'read map' }, $
			{ CW_PDMENU_S,			0, 'read components (axb)' }, $
			{ CW_PDMENU_S,			2, 'read stack' } $
]	; End of STACK Process

Axis_Menu_List = [Axis_Menu_List, $
	; LINESCAN Process
	{ CW_PDMENU_S,			1, 'Linescans' }, $
		{ CW_PDMENU_S,			1, 'Add lines' }, $
			{ CW_PDMENU_S,			0, 'horizontal' }, $
			{ CW_PDMENU_S,			2, 'vertical' }, $
		{ CW_PDMENU_S,			1, 'align' }, $
			{ CW_PDMENU_S,			0, 'linear' }, $
	      	{ CW_PDMENU_S,			2, 'curve' }, $
		{ CW_PDMENU_S,			0, 'line_fit' }, $
		{ CW_PDMENU_S,			0, 'locate line' }, $
		{ CW_PDMENU_S,			0, 'normalize to Io' }, $
		{ CW_PDMENU_S,			1, 'normalize to line' }, $
			{ CW_PDMENU_S,			0, 'horizontal' } , $
			{ CW_PDMENU_S,			2, 'vertical' } , $
		{ CW_PDMENU_S,			2, 'subtract reference' } $
]	; End of LINESCAN Process

Axis_Menu_List = [Axis_Menu_List, $
	; SPECTRA Process
	{ CW_PDMENU_S,			1, 'Spectra' }, $
		{ CW_PDMENU_S,			0, 'Absolute value' }, $
		{ CW_PDMENU_S,			1, 'Add' }, $
			{ CW_PDMENU_S,			0, 'Append' }, $
			{ CW_PDMENU_S,			0, 'Buffer' }, $
			{ CW_PDMENU_S,			2, 'Constant' }, $
		{ CW_PDMENU_S,			1, 'Calibrate' }, $
			{ CW_PDMENU_S,			1, 'X' }, $
				{ CW_PDMENU_S,			0, 'auto' }, $
				{ CW_PDMENU_S,			0, '1 point' }, $
				{ CW_PDMENU_S,			0, '2 point' }, $
				{ CW_PDMENU_S,			2, 'numerical' }, $
			{ CW_PDMENU_S,			3, 'Y' }, $
				{ CW_PDMENU_S,			0, 'auto' }, $
				{ CW_PDMENU_S,			0, '1 point' }, $
				{ CW_PDMENU_S,			0, '2 point' }, $
				{ CW_PDMENU_S,			2, 'numerical' }, $
		{ CW_PDMENU_S,			1, 'Convert to'}, $
				{ CW_PDMENU_S,			0, 'OD'}, $
				{ CW_PDMENU_S,			0, 'OD1'}, $
				{ CW_PDMENU_S,			2, 'IP' }, $
		{ CW_PDMENU_S,			1, 'Curve fit' }, $
			{ CW_PDMENU_S,			0, 'linear regression' }, $
			{ CW_PDMENU_S,			0, 'CGO fit' }, $
			{ CW_PDMENU_S,			2, 'polarization fit' }, $
		{ CW_PDMENU_S,			0, 'Delete' }, $
		{ CW_PDMENU_S,			0, 'Differentiate' }, $
		{ CW_PDMENU_S,			1, 'Gain' }, $
			{ CW_PDMENU_S,			0, 'multiply' }, $
			{ CW_PDMENU_S,			2, 'divide' }, $
		{ CW_PDMENU_S,			0, 'E_to_Wavelength' }, $
		{ CW_PDMENU_S,			0, 'exp(Y)' }, $
		{ CW_PDMENU_S,			0, 'Integrate' }, $
		{ CW_PDMENU_S,			0, 'ln(Y)' }, $
		{ CW_PDMENU_S,			0, 'log10(Y)' }, $
		{ CW_PDMENU_S,			0, 'Linear Background' }, $
		{ CW_PDMENU_S,			0, 'Modify one point' }, $
		{ CW_PDMENU_S,			0, 'Multiply' }, $
		{ CW_PDMENU_S,			0, 'Peak area' }, $
		{ CW_PDMENU_S,			0, 'Ratio_to' }, $
		{ CW_PDMENU_S,			0, 'Reverse values' }, $
		{ CW_PDMENU_S,			0, 'Split' }, $
		{ CW_PDMENU_S,			2, 'Truncate' } $
]	; End of SPECTRA Process

Axis_Menu_List = [Axis_Menu_List, $
	; Display Process
		{ CW_PDMENU_S,			1, 'Display' }, $
		{ CW_PDMENU_S,			1, 'Over Plot' }, $	; Over Plot (SPECTRA only)
			{ CW_PDMENU_S,			0, 'No Rescale' }, $
			{ CW_PDMENU_S,			0, 'Rescale' }, $
			{ CW_PDMENU_S,			0, 'Window' }, $
			{ CW_PDMENU_S,			2, 'Shift' }, $
		{ CW_PDMENU_S,			1, 'Clear' }, $
			{ CW_PDMENU_S,			0, 'Lines' }, $
			{ CW_PDMENU_S,			0, 'Current' }, $
			{ CW_PDMENU_S,			0, 'Selected' }, $
			{ CW_PDMENU_S,			2, 'All' }, $
		{ CW_PDMENU_S,			0, '3d plot' } , $
		{ CW_PDMENU_S,			0, 'Modify image colors' }, $
		{ CW_PDMENU_S,			0, 'Modify rigid colors' }, $
		{ CW_PDMENU_S,			0, 'Pixels only' }, $
		{ CW_PDMENU_S,			0, 'RGB composite' }, $
		{ CW_PDMENU_S,			0, 'Scale bar position' }, $
		{ CW_PDMENU_S,			0, 'Show color scheme' }, $
		{ CW_PDMENU_S,			3, 'Thumbnails' }, $
			{ CW_PDMENU_S,			1, '4' }, $
				{ CW_PDMENU_S,			0, 'common scale' }, $
				{ CW_PDMENU_S,			2, 'rescale each' }, $
			{ CW_PDMENU_S,			3, '9' }, $
				{ CW_PDMENU_S,			0, 'common scale' }, $
				{ CW_PDMENU_S,			2, 'rescale each' } $
]	; End of DISPLAY Process


Axis_Menu_List = [Axis_Menu_List, $
	; UTILITIES Process
	{ CW_PDMENU_S,			1, 'Utilities' }, $
		{ CW_PDMENU_S,			1, 'Print' }, $
			{ CW_PDMENU_S,			0, 'Logbook' }, $
			{ CW_PDMENU_S,			2, 'Annotated' }, $
		{ CW_PDMENU_S,			0, 'Change label' }, $
		{ CW_PDMENU_S,			0, 'Change mesh' }, $
		{ CW_PDMENU_S,			0, 'Calculate X-ray parameters (SF)' }, $
		{ CW_PDMENU_S,			0, 'Calculate peptide spectra' }, $
		{ CW_PDMENU_S,			0, 'Execute macro' }, $
;		{ CW_PDMENU_S,			0, 'PEEMVision (Scholl Jan 2007)' }, $
		{ CW_PDMENU_S,			0, 'Set energy' }, $
		{ CW_PDMENU_S,			0, 'Set preferences' }, $
		{ CW_PDMENU_S,			0, 'Print SysVar' }, $
		{ CW_PDMENU_S,			3, 'Write image ascii' }, $
			{ CW_PDMENU_S,			0, 'reals' }, $
			{ CW_PDMENU_S,			2, 'integers' } $
;		{ CW_PDMENU_S,			2, 'Help' } $
]	; End of UTILITIES Process

;Axis_Menu_List = [Axis_Menu_List, $
;	; COPY Process
;	{ CW_PDMENU_S,			1, 'Copy' }, $
;		{ CW_PDMENU_S,			2, 'Copy' } $
;]	; End of COPY Process

; End of pull down menus creation

; Create single function buttons to complement pull-down menus

Axis_Button_List1 = [ $
	{ CW_PDMENU_S,			0, 'Exit' }, $	; quit AXIS and save parameters
	{ CW_PDMENU_S,			0, 'Quit' }, $	; quit AXIS without saving parameters
    { CW_PDMENU_S,			0, 'XimageViewer' }, $	; quit AXIS without saving parameters
	{ CW_PDMENU_S,			2, '  Help  ' } $
]
Axis_Button_List2 = [ $
	{ CW_PDMENU_S,			0, 'Reset colors' }, $
	{ CW_PDMENU_S,			0, 'Copy Buffer' }, $
	{ CW_PDMENU_S,			2, 'Clear Buffer' } $
;	{ CW_PDMENU_S,			2, 'Help' } $
]
; End of pull down menus creation

; Set up parameters for dialog window
IF (n_elements(gr_scale) EQ 0) THEN gr_scale = 1.0	; start with image zoom of 1
IF (n_elements(mouse) EQ 0) THEN mouse = 1		; start with continuous line-outs

;gr_dev = 'MAC'
Thumbnail = intarr(10)
BufLbls = strarr(10)		; Setup array for button labels
BufLbls(0) = ' 0  Working Buffer                           '	; Initialize array for button labels
For i = 1, 9 DO BufLbls(i) = (STRCOMPRESS(STRING(i))) + '  Empty                                                         '

; *******  set up paramaterized graph sizes with scaling factors *****
main_size = 360*gr_scale		; width of main draw window
side_size = 120*gr_scale		; width of X-lineout window
thumb_size = 51					; size of thumbnail
gap = 2							; size of gap between thumbnails
top_offset = 32					; space for pull-down menus
xyz_width = 9					;  number of characters in labels

; ------- set up window scroll if needed  ----------------
; use scroll bar in Window but not otherwise

if !version.os_family EQ 'Windows' then $
axis_base = widget_base(/col, GROUP_LEADER=Group, TITLE= 'aXis2000 ' + axis_ver, space=0., /scroll) $
       else axis_base = widget_base(/col, GROUP_LEADER=Group, TITLE= 'aXis2000 ' + axis_ver, space=0.)
top_row = widget_base(axis_base,/row)
Axis_Menu = CW_PDMENU( top_row, Axis_Menu_List, uvalue='AxisMenu', /RETURN_FULL_NAME, /mbar)

top_row = widget_base(axis_base,/row)
Axis_Button1 = CW_PDMENU( top_row, Axis_Button_List1, uvalue='AxisButton1', /RETURN_FULL_NAME, /mbar)
dummy = widget_base(top_row,/col,xsize=0.9*main_size)
Axis_Button2 = CW_PDMENU( top_row, Axis_Button_List2, uvalue='AxisButton2', /RETURN_FULL_NAME, /mbar)

top_row = widget_base(axis_base,/row)
col1 = widget_base(top_row,/col)
col2 = widget_base(top_row,/col)

; YZ Profile
row = widget_base(col1,/row,/align_right)
yz_profile = widget_draw( row, retain = 2, uvalue ='yz_profile', $
      xsize = side_size, ysize = main_size)

row = widget_base(col2,/row,/align_left)
; Main Image
main_image = widget_draw( row, /button_events, retain = 2, uvalue = 'main_image', $
      xsize = main_size, ysize = main_size)
   ; reset to need click to update x,y,z and line-outs (aph 11-dec-97)

row = widget_base(col2,/row,/align_left)
; XZ Profile
xz_profile = widget_draw( row, retain = 2, uvalue = 'xz_profile', $
      xsize = main_size, ysize = side_size)

; Numerical info from cursors
row = widget_base(col1,/row)
col1a = widget_base(row,/col)
col1b = widget_base(row,/col)
col1c = widget_base(row,/col)

; (x,y,z) display
lablsize=12
valsize=56
pixelsize = 32
label_txt = widget_label( col1a, value='X', xsize = lablsize)
label_txt = widget_label( col1a, value='Y', xsize = lablsize)
label_txt = widget_label( col1a, value='Z', xsize = lablsize)
cursor_x = widget_label( col1b, uvalue='label_x', value=' ', xsize=valsize)
cursor_y = widget_label( col1b, uvalue='label_y', value=' ', xsize=valsize)
curs_pix_x = widget_label( col1c, uvalue='pixel_x', value=' ', xsize=pixelsize)
curs_pix_y = widget_label( col1c, uvalue='pixel_y', value=' ', xsize=pixelsize)
cursor_z = widget_label( col1b, uvalue='label_z', value=' ', xsize=80)
dummy = widget_label(col1a, value = ' ', frame=0,  xsize=lablsize)
dummy = widget_label(col1b, value = ' ', frame=0,  xsize=80)

; delta (x,y,z) display
lablsize=20
label_txt = widget_label( col1a, value='dX', xsize = lablsize)
label_txt = widget_label( col1a, value='dY', xsize = lablsize)
label_txt = widget_label( col1a, value='dR', xsize = lablsize)
label_txt = widget_label( col1a, value='dZ', xsize = lablsize)
cursor_dx = widget_label( col1b, uvalue='label_dx', value=' ', xsize=80)
cursor_dy = widget_label( col1b, uvalue='label_dy', value=' ', xsize=80)
cursor_dr = widget_label( col1b, uvalue='label_dr', value=' ', xsize=80)
cursor_dz = widget_label( col1b, uvalue='label_dz', value=' ', xsize=80)


; OPTIONS switches at bottom
test = intarr(3)                     ; establish initial values
test(0) = mouse
test(1) = line_sym
test(2) = scale_bar
OptBtns = ['Z-lines', 'Symbols', 'Bar']
row = widget_base(col2,/row,/align_left, space=0)
IF (gr_scale LT 0.9) THEN BEGIN
	OptButs = CW_BGROUP(row, OptBtns, /col, /NONEXCLUSIVE, set_value = test, uvalue='OptButs')
ENDIF ELSE BEGIN
	OptButs = CW_BGROUP(row, OptBtns, /row, /NONEXCLUSIVE, set_value = test, uvalue='OptButs')
ENDELSE

; --------------- Gamma controls
;label_txt =  widget_label(row, value = 'G ', /align_center)	;,
g_slider = widget_slider(row, /align_center, uvalue = "GAMMA", $
      minimum = 0, maximum = 100, value = 50, scr_ysize = 10, $
       sensitive = 1, /suppress_value)
g_lbl =  widget_text(row,/align_left, $ ; value = STRING(1.0, format='(f4.2)'), $
		 uvalue = "G_lbl", xsize=4,/editable, sensitive = 0)

; Color Bar and upper, lower limits
; Display intensity controls
col3 = widget_base(top_row,/col)
row = widget_base(col3,/row,/align_left)
col = widget_base(row,/col,space=0)
Zmax = widget_text(col, /editable, sensitive = 0, uvalue='Zmax', $
        value=' ', xsize=xyz_width, frame=0, /align_left)
color_bar_image = widget_draw(col, /button_events, retain=2, uvalue='color_bar_image', $
      xsize= 0.04*main_size, ysize=0.86*main_size, /align_center)
Zmin = widget_text(col, /editable, sensitive = 0, uvalue='Zmin', $
        value=' ', xsize=xyz_width, frame=0, /align_left)

dummy = widget_label(col, value = ' ', frame=0)

; Y-max, Y-min controls
row = widget_base(col3,/row,/frame)
col = widget_base(row,/col,space=0)
YYmax = widget_text( col, /editable, sensitive = 0, uvalue='YYmax', $
		Value = '', Xsize = xyz_width, /align_center)
label_txt = widget_label( col, value='Y', /align_center)
YYmin = widget_text( col, /editable, sensitive = 0, uvalue='YYmin', $
		Value = '', Xsize = xyz_width, /align_center)

dummy = widget_label(col, value = ' ', frame=0)

; X-max, X-min controls
XXmax = widget_text( col, /editable, sensitive = 0, uvalue='XXmax', $
		Value = '', Xsize = xyz_width, /align_center)
label_txt = widget_label( col, value='X', /align_center)
XXmin = widget_text( col, /editable, sensitive = 0, uvalue='XXmin', $
		Value = '', Xsize = xyz_width, /align_center)

; --------- Thumbnail images ---------------------------
col4 = widget_base(top_row,/col)
thumbs = widget_base(col4)
thumb_1 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_1', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=0, YOFFSET=0 )
thumb_2 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_2', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=thumb_size+gap, YOFFSET=0 )
thumb_3 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_3', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=2*(thumb_size+gap), YOFFSET=0 )
thumb_4 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_4', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=0, YOFFSET=thumb_size+gap )
thumb_5 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_5', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=thumb_size+gap, YOFFSET=thumb_size+gap )
thumb_6 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_6', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=2*(thumb_size+gap), YOFFSET=thumb_size+gap )
thumb_7 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_7', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=0 , YOFFSET=2*(thumb_size+gap) )
thumb_8 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_8', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=thumb_size+gap , YOFFSET=2*(thumb_size+gap) )
thumb_9 = widget_draw( thumbs, /button_events, retain=2, uvalue='thumb_9', $
					XSIZE=thumb_size, ysize=thumb_size, $
					XOFFSET=2*(thumb_size+gap) , YOFFSET=2*(thumb_size+gap) )

; ----------- Right-most column of stuff -----------

row = widget_base(col4,/row)
Uprompt = widget_text(col4, /frame, /wrap, uvalue='Uprompt', /scroll, $
			value='Welcome to aXis2000', ysize=6)

row = widget_base(col4,/row)
BufButs = CW_BGROUP( row, BufLbls, /col, /nonexclusive, /scroll, $
		X_SCROLL_SIZE = 4*thumb_size, $
		IDS = ButIDs, uvalue='BufButs', $
		xsize = 600, space=0 )

; --------------- load logo files silently ------------
;  if keyword_set(spin) then ax_load_logo, /axis
;  ax_load_logo, /axis

;Device, get_screen_size=screen_size
screen_size=get_screen_size()
screen_center = [ screen_size(0) / 2 , screen_size(1) / 2 ]
geom = Widget_Info(axis_base, /Geometry)
base_size = [geom.scr_xsize,geom.scr_ysize]
x_base_size = (fix(0.90*screen_size[0]) < base_size[0])
y_base_size = (fix(0.95*screen_size[1]) < base_size[1])
halfsize = [ x_base_size / 2 , y_base_size / 2 ]
widget_control, axis_base, $
	XOffset = screen_center[0] - halfsize[0], $
	YOffset = screen_center[1] - halfsize[1], $
	scr_xsize = x_base_size, $
	scr_ysize = y_base_size

;
;	could autoscale gr_scale here and restart axis_dialog
;

; force black background on start-up
!p.background = 0

widget_control, axis_base, $
	XOffset = (screen_size[0] - geom.scr_xsize) / 2, $
	YOffset = (screen_size[1] - geom.scr_ysize) / 2


widget_control, axis_base, /realize, /update

;	; check if widget is larger then screen and adjust size if needed
;	screen_size = get_screen_size()
;	print,'screen size : ',screen_size
;	widget_control, axis_base, tlb_get_offset=base_offset
;	widget_control, axis_base, tlb_get_size=base_size
;	x_base_size = (fix(0.9*screen_size[0] - base_offset[0]) < base_size[0])
;	y_base_size = (fix(0.9*screen_size[1] - base_offset[1]) < base_size[1])
;	IF ((x_base_size NE base_size[0]) OR (y_base_size NE base_size[1])) THEN BEGIN
;		widget_control, axis_base, scr_xsize = x_base_size, scr_ysize = y_base_size
;	ENDIF

;Get the widget ID's for the labels
Axis_Window = !d.window		; save Widget_ID of the top level guy
Axis_ID = axis_base		; save Widget_ID of the top level guy
MainWid = main_image
cursorX = cursor_x           ; cursor in data units
cursorY = cursor_y
pixelX = curs_pix_x          ; cursor in pixel units
pixelY = curs_pix_y
cursorZ = cursor_z			 ; data value at cursor
delX = cursor_dx              ; change (on mouse click)
delY = cursor_dy
delR = cursor_dr
delZ = cursor_dz

; Get draw window ID values for reference elsewhere (transfered through AXIS_COM)
widget_control, main_image, GET_value=MainImg
widget_control, xz_profile, GET_value=XZPlot
widget_control, yz_profile, GET_value=YZPlot
widget_control, color_bar_image, GET_value=ColorbarPlot
widget_control, thumb_1, GET_value= t & Thumbnail(1) = t
widget_control, thumb_2, GET_value= t & Thumbnail(2) = t
widget_control, thumb_3, GET_value= t & Thumbnail(3) = t
widget_control, thumb_4, GET_value= t & Thumbnail(4) = t
widget_control, thumb_5, GET_value= t & Thumbnail(5) = t
widget_control, thumb_6, GET_value= t & Thumbnail(6) = t
widget_control, thumb_7, GET_value= t & Thumbnail(7) = t
widget_control, thumb_8, GET_value= t & Thumbnail(8) = t
widget_control, thumb_9, GET_value= t & Thumbnail(9) = t

if mouse EQ 1 then widget_control, main_image, draw_MOTION_EVENTS = 1


return
end