; Copyright (c) 1998-2001 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	MAKE_SQUARE
;
;LAST CHANGED: ----------------------------------- 12-may-02
;
; PURPOSE:
;	This procedure replaces rectangular images with a square image
; extended with gray space
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
; for procedures:
;	MAKE_SQUARE, S
;
; INPUTS:
; 	S		AXIS structure data (only operates on t='2d', images
;
; KEYWORDS: none
;
; OUTPUTS: square matrix is returned as the entry structure
;
; COMMON BLOCKS: none
;
; MODIFICATION HISTORY:
; (xxDec-99 aph) ~time introduced
; (30-dec-00 aph) Xrng and Yrng set up
;				AXIS standard header added
; (05-mar-01 aph) trying to debug bad read in of some ALS 7.0 linescans (error not found)
;912-may-02 aph) fix up header name format.
;-
pro make_square,s

if s.t NE '2d' then return
nx = n_elements(s.x)
ny = n_elements(s.y)
if nx EQ ny then return
dval = max(s.d)
if nx GT ny then begin
	y = fltarr(nx)            ; extend y range to make it match x-range
	x = s.x
	d = fltarr(nx,nx)
	y(0:ny-1) = s.y
	d(*,0:ny-1) = s.d
	dy = s.y(ny-1)-s.y(ny-2)
	for i = 0, nx-ny-1 do begin
		y(ny+i)= y(ny-1)+i*dy
		d(*,ny+i) = dval 	; sets extra pixels to top color (white)
    endfor
;    print, 'non-square data: extended y-range'
endif  else begin
	x = fltarr(ny)            ; extend x range to make it match  yrange
	y = s.y
	d = fltarr(ny,ny)
;	help, s,/struct
;	help,d
	x(0:nx-1) = s.x
	d(0:nx-1,*) = s.d
	dx = s.x(nx-1)-s.x(nx-2)
	for i = 0, ny-nx-1 do begin
		x(nx+i)= x(nx-1)+i*dx
		d(nx+i,*) = dval
    endfor
;    print, 'non-square data: extended x-range'
endelse
sn = {t:s.t,x:x,y:y,d:d,xl:s.xl,yl:s.yl,dl:s.dl}
s = sn
return
end

