; Copyright (c) 1996, ALS SpectroMicroscopy Facility, jdd 
;  **** *********** splot3d removed ****** rel to jdd's version (splot) ******* 
;+ 
; FILE: splota.pro 
; 
; last changed: ------------------------------  30-nov-00
; 
; REQUIREMENTS:  graph.pro MUST be compiled prior 
; 
; CONTENTS: 
;  pro SPLOT, s1 [, opt, _extra=e] 
;      options: /O - overplot 
;               /DN - plot dn: field (data norm) 
;               /WB - white on black 
;               /ZERO - autoscale y from 0 
;               _extra=e - pass along PLOT options 
;  pro SPLOT2D, s2  [, /ASPECT, opt]	-- image plot with axes 
;      /ASPECT resizes window height to match make dx~dy 
;  pro SPLOT3D, s2  [,opt]	-- surface plot with axes 
; 
; INPUTS 
;     basic input data structure: s1={d:, x:}, s2={d:, x:, y:} 
;     optional axis and title label fields include {xl:, yl:, dl:} 
; 
; COMMON: axis_com 
; 
; REVISIONS 
; 2/19/96  initial creation 
; 6/15/96  jdd added generalized interpretation of structures 
;              in SPLOT, SPLOT2D, SPLOT3D 
;              separated splot stuff from graph.pro 
; 6/29/96  aph allow numerical limts on ranges 
; (06-Dec-97 aph) remove print of ytitle 
; (03-jan-99 aph) add back in YTitle (!!) 
; (24-jun-99 aph) consistent image/spectra color tables 
; (13-aug-99 aph) no change - just using debugs to track reform problem 
; (15-nov-00 cgz) Replaced call of NCOLS function by explicit (SIZE(var))(1)
; (30-nov-00 cgz) Replaced call of WSIZE function by explicit [!D.X_SIZE,!D.Y_SIZE]
; (30-nov-00 cgz) Replaced call of nwin with explicit window statement
;- 
 
pro splot, s, O=oplot, DN=dn, WB=wb, CHARSIZE=csz, COLOR=clr, $ 
    ZERO=zero,  _extra=e 
;-------------------------------------- 
; basic 1-D structure {d:data, x:xaxis} 
; optional label fields{ dl:, xl:} fields for xaxis and data label 
; optional field is {dn:} for data normalization 
; options:  /O -- overplot 
;           O=iclr -- overplot with color=iclr 
 
@axis_com
on_error,2 
 
yst=16 
if keyword_set(zero) then yst=0 
; if keyword_set(e) then print,e   ;aph - deleted printing of extra opts 
zdata=s.d 
if keyword_set(dn) then zdata=s.dn 
iclr=[0,255]	; default to Black-on-White 
if keyword_set(wb) then iclr=[255,0] 
if keyword_set(clr) then iclr(0)=clr 
 
if keyword_set(oplot) then begin 
   if not keyword_set(clr) then iclr(0)=128 
   if oplot gt 1 then iclr(0)=oplot 
   oplot, s.x, zdata, color=iclr(0), _extra=e 
endif else begin 
   if not keyword_set(csz) then csz=1.5	;nominal character size 
   if not keyword_set(clr) then clr=0 
   xl='' & yl = '' & dl='' 
   if stag(s,'xl') then xl=s.xl 
   if stag(s,'yl') then yl=s.yl 
   if stag(s,'dl') then dl=s.dl 
   plot, s.x, zdata, $ 
      xtitle=xl, xstyle=1, ystyle=yst, title=dl, ytitle = yl, $ 
      color=iclr(0), back=iclr(1), charsize=csz, _extra=e 
endelse 
end 
 
pro splot2d, s, ASPECT=asp,ZOOM=zoom, _extra=e 
;------------------------ 
; basic 2-D structure contains {d:, x:, y:} fields 
; optional label fields { dl:, xl:, yl:} 
; options: /ASPECT rescale window vertical size to 
;          aspect ratio similar to the image dimensions 
;          /ZOOM allows user to define x,y ranges 
 
@axis_com
on_error,2 
 
dl='' & xl='' & yl='' 
fexist=stag(s, ['dl', 'xl', 'yl']) 
if fexist(0) then dl=s.dl 
if fexist(1) then xl=s.xl 
if fexist(2) then yl=s.yl 
 
; determine indices of s.d within xrange, yrange 
nxb=0 
xmin=s.x(0) 
;nxe=ncols(s.x)-1 
nxe=(size(s.x))(1)-1 
xmax=s.x(nxe) 
nyb=0 
ymin=s.y(0) 
;nye=ncols(s.y)-1 
nye=(size(s.y))(1)-1 
ymax=s.y(nye) 
if keyword_set(zoom) then begin 
	prom=string(s.x(0)) + ' Xmin:' 
	READ, xmin, PROMPT= prom 
	prom=string(s.x(nxe)) + ' Xmax:' 
	READ, xmax, PROMPT= prom 
	prom=string(s.y(0)) + ' Ymin:' 
	READ, ymin, PROMPT= prom 
	prom=string(s.y(nye)) + ' Ymax:' 
	READ, ymax, PROMPT= prom 
;	for i=0, ncols(s.x)-1 do begin 
	for i=0, (size(s.x))(1)-1 do begin 
	   if s.x(i) le xmin then nxb=i 
	   if s.x(i) lt xmax then nxe=i 
	   if s.y(i) le ymin then nyb=i 
	   if s.y(i) lt ymax then nye=i 
	endfor 
endif 
 
if keyword_set(asp) then begin 
   sz=size(s.d) 
   dx=abs(xmax-xmin) 
   dy=abs(ymax-ymin) 
   aspect=dy/dx*1.2 
   print, dx, dy, aspect/1.2 
;   ws=wsize() 
	ws = [ !D.X_SIZE, !D.Y_SIZE ] 
   nwin, !d.window+(!d.window eq -1), ws(0), round(ws(0)*aspect) 
endif 
plot2d, s.d(nxb:nxe,nyb:nye), s.x(nxb:nxe), s.y(nyb:nye), [xl, yl], title=dl, _extra=e 
 
end 
 
 
pro splot3d, s, ASPECT=asp, ZOOM=zoom, _extra=e 
;------------------------ 
; basic 2-D structure contains {d:, x:, y:} fields 
; optional label fields { dl:, xl:, yl:} 
; options: /ASPECT rescale window vertical size to 
;          aspect ratio similar to the image dimensions 
;          /ZOOM allows user to define x,y ranges 
 
@axis_com
on_error,2 
 
dl='' & xl='' & yl='' 
fexist=stag(s, ['dl', 'xl', 'yl']) 
if fexist(0) then dl=s.dl 
if fexist(1) then xl=s.xl 
if fexist(2) then yl=s.yl 
 
; determine indices of s.d within xrange, yrange 
nxb=0 
xmin=s.x(0) 
;nxe=ncols(s.x)-1 
nxe=(size(s.x))(1)-1 
xmax=s.x(nxe) 
nyb=0 
ymin=s.y(0) 
;nye=ncols(s.y)-1 
nye=(size(s.y))(1)-1 
ymax=s.y(nye) 
if keyword_set(zoom) then begin 
	prom=string(s.x(0)) + ' Xmin:' 
	READ, xmin, PROMPT= prom 
	prom=string(s.x(nxe)) + ' Xmax:' 
	READ, xmax, PROMPT= prom 
	prom=string(s.y(0)) + ' Ymin:' 
	READ, ymin, PROMPT= prom 
	prom=string(s.y(nye)) + ' Ymax:' 
	READ, ymax, PROMPT= prom 
;	for i=0, ncols(s.x)-1 do begin 
	for i=0, (size(s.x))(1)-1 do begin 
	   if s.x(i) le xmin then nxb=i 
	   if s.x(i) lt xmax then nxe=i 
	   if s.y(i) le ymin then nyb=i 
	   if s.y(i) lt ymax then nye=i 
	endfor 
endif 
 
if keyword_set(asp) then begin 
   sz=size(s.d) 
   dx=abs(xmax-xmin) 
   dy=abs(ymax-ymin) 
   aspect=dy/dx*1.2 
   print, dx, dy, aspect/1.2 
;   ws=wsize() 
	ws = [ !D.X_SIZE, !D.Y_SIZE ] 
   nwin, !d.window+(!d.window eq -1), ws(0), round(ws(0)*aspect) 
   nwin, !d.window>0, ws(0), round(ws(0)*aspect) 
endif 
plot3d, s.d(nxb:nxe,nyb:nye), s.x(nxb:nxe), s.y(nyb:nye), [xl, yl], title=dl, _extra=e 
 
end 
