PRO read_stxm, file, sd, khz, $ 
        header_only=header_only, nocopybytes=nocopybytes, $ 
        help=help 
 
;+ 
; pro read_stxm, file, sd 
; -------------------------------------------- last changed: 9-Sep-99 
; 
; Reads in a STXM image from netCDF format. 
; 
; It puts the image and associated information 
; into BSIF_COMMON variables: 
;   image_data (the array which holds the image - possible several 
;		        planes deep for I, IO, CLOCK) 
;   x_normal, y_normal, rotated, x_title, y_title, 
;   x_dist, and y_dist 
; 
; The STXM scan data is put into "sd" 
;- 
; -------------------- REVISION HISTORY ------------------------ 
; Based on Mark Rivers stuff; Chris Jacobsen, June 1993 
; CHANGES 
;   Version 1.0 had the attribute "sd.operator", which in 
;     version 1.1 is called "operator".  Chris Jacobsen, August 27, 1993 
;   Version 1.2 was a change in writing - x_title and y_title were 
;     forced to be string arrays.  No change in reading. CJ, 02 Nov 93 
;   Version 1.3 added keyword /continue to message command so control 
;     is returned to the calling level.  Henry Chapman, 23 Jun 95. 
;   Changed copy_bytes to not be called if requested, and not to 
;     be called under Windows.  CJ, 4 Nov. 1997. 
; (aph 12-jan-99) on_IOerror added to handle *.sl with extral line at end 
; (aph 15-May-99) drop first line to remove glitches 
; (aph 20-may-99) REMOVED last change since it gave errors if no existing image_data 
; (09-sep-99 aph) change to get meaningful (x,y) scales in stacks (X_start, Y_start) 
;               but not implemented !! 
 
if (keyword_set(help) or (n_elements(file) eq 0)) then begin 
    print,'read_stxm,filename,sd' 
    print,'  Reads in a STXM netCDF file.' 
    print,'  The STXM scan data is put into "sd".' 
    return 
endif 
 
on_error, 2 
@bsif_common
 
find_the_file=findfile(file) 
if (find_the_file(0) eq '') then begin 
    message,'File "'+file+'" not found.' 
    return 
endif 
 
; Open the file to be read 
on_IOerror, bailout 
cdfid = ncdf_open(file, /NOWRITE) 
 
; Retrieve global attributes 
ncdf_inq = ncdf_inquire( cdfid ) 
ncdf_attget, cdfid, /GLOBAL, "title", image_title 
image_title=string(image_title) 
if (ncdf_inq.ngatts lt 2) then begin 
    print,' Not a STXM netCDF version 1.0--1.2 file! (<2 global attributes)' 
    stxm_netcdf_version='0' 
endif else begin 
    ncdf_attget, cdfid, /GLOBAL, "stxm_netcdf_version", stxm_netcdf_version 
    stxm_netcdf_version=string(stxm_netcdf_version) 
    if ((stxm_netcdf_version ne '1.0') and $ 
        (stxm_netcdf_version ne '1.1') and $ 
        (stxm_netcdf_version ne '1.2')) then begin 
        print,'  Not a STXM netCDF version 1.0--1.2 file!' 
        print,'  Version is "'+stxm_netcdf_version+'".' 
    endif 
endelse 
 
; Set up dimensions 
ncdf_diminq, cdfid, 0, dummy, n_cols 
ncdf_diminq, cdfid, 1, dummy, n_rows 
ncdf_diminq, cdfid, 2, dummy, n_data 
ncdf_diminq, cdfid, 3, dummy, n_chars 
 
image_data_id = ncdf_varid(cdfid, 'image_data') 
data_title_id = ncdf_varid(cdfid, 'data_title') 
; x_dist_id = ncdf_varid(cdfid, 'x_dist') 
; y_dist_id = ncdf_varid(cdfid, 'y_dist') 
 
; Retrieve BSIF information 
ncdf_attget, cdfid, image_data_id, "x_normal", x_normal 
ncdf_attget, cdfid, image_data_id, "y_normal", y_normal 
ncdf_attget, cdfid, image_data_id, "rotated", rotated 
ncdf_attget, cdfid, image_data_id, "x_start", x_start 
ncdf_attget, cdfid, image_data_id, "x_stop", x_stop 
ncdf_attget, cdfid, image_data_id, "y_start", y_start 
ncdf_attget, cdfid, image_data_id, "y_stop", y_stop 
ncdf_attget, cdfid, image_data_id, "x_title", x_title 
ncdf_attget, cdfid, image_data_id, "y_title", y_title 
 
init_stxm_sd,sd 
ncdf_attget, cdfid, image_data_id, "version_number", t 
sd.version_number=t 
ncdf_attget, cdfid, image_data_id, "scan_driver_mode", t 
sd.scan_driver_mode=t 
ncdf_attget, cdfid, image_data_id, "scan_width", t 
sd.scan_width=t 
ncdf_attget, cdfid, image_data_id, "scan_height", t 
sd.scan_height=t 
ncdf_attget, cdfid, image_data_id, "i0_mode", t 
sd.i0_mode=t 
ncdf_attget, cdfid, image_data_id, "clock_frequency", t 
sd.clock_frequency=t 
ncdf_attget, cdfid, image_data_id, "sd_x_start", t 
sd.x_start=t 
ncdf_attget, cdfid, image_data_id, "sd_x_stop", t 
sd.x_stop=t 
ncdf_attget, cdfid, image_data_id, "x_center", t 
sd.x_center=t 
ncdf_attget, cdfid, image_data_id, "x_step_size", t 
sd.x_step_size=t 
ncdf_attget, cdfid, image_data_id, "sd_y_start", t 
sd.y_start=t 
ncdf_attget, cdfid, image_data_id, "sd_y_stop", t 
sd.y_stop=t 
ncdf_attget, cdfid, image_data_id, "y_center", t 
sd.y_center=t 
ncdf_attget, cdfid, image_data_id, "y_step_size", t 
sd.y_step_size=t 
ncdf_attget, cdfid, image_data_id, "z_start", t 
sd.z_start=t 
ncdf_attget, cdfid, image_data_id, "z_stop", t 
sd.z_stop=t 
ncdf_attget, cdfid, image_data_id, "z_center", t 
sd.z_center=t 
ncdf_attget, cdfid, image_data_id, "z_step_size", t 
sd.z_step_size=t 
ncdf_attget, cdfid, image_data_id, "focus_position", t 
sd.focus_position=t 
ncdf_attget, cdfid, image_data_id, "dwell_time", t 
sd.dwell_time=t 
ncdf_attget, cdfid, image_data_id, "x_prescan_distance", t 
sd.x_prescan_distance=t 
ncdf_attget, cdfid, image_data_id, "y_prescan_distance", t 
sd.y_prescan_distance=t 
ncdf_attget, cdfid, image_data_id, "x_postscan_distance", t 
sd.x_postscan_distance=t 
ncdf_attget, cdfid, image_data_id, "x_postscan_distance", t 
sd.x_postscan_distance=t 
ncdf_attget, cdfid, image_data_id, "flyback_velocity", t 
sd.flyback_velocity=t 
ncdf_attget, cdfid, image_data_id, "entrance_slit", t 
sd.entrance_slit=t 
ncdf_attget, cdfid, image_data_id, "exit_slit", t 
sd.exit_slit=t 
ncdf_attget, cdfid, image_data_id, "wavelength", t 
sd.wavelength=t 
ncdf_attget, cdfid, image_data_id, "date_time", t 
sd.date_time=byte(string(t)) 
if (stxm_netcdf_version eq '1.0') then begin 
    ncdf_attget, cdfid, image_data_id, "sd.operator", t 
    sd.operator=byte(string(t)) 
endif else if ( (stxm_netcdf_version eq '1.1') or $ 
                (stxm_netcdf_version eq '1.2') ) then begin 
    ncdf_attget, cdfid, image_data_id, "operator", t 
    sd.operator=byte(string(t)) 
endif 
ncdf_attget, cdfid, image_data_id, "sample", t 
sd.sample=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "zone_plate", t 
sd.zone_plate=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "comment1", t 
sd.comment1=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "comment2", t 
sd.comment2=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "file_name", t 
sd.file_name=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "ring_current", t 
sd.ring_current=t 
ncdf_attget, cdfid, image_data_id, "undulator_gap", t 
sd.undulator_gap=t 
ncdf_attget, cdfid, image_data_id, "idling_time", t 
sd.idling_time=t 
ncdf_attget, cdfid, image_data_id, "auto_shutter", t 
sd.auto_shutter=t 
ncdf_attget, cdfid, image_data_id, "x_pzt_offset", t 
sd.x_pzt_offset=t 
ncdf_attget, cdfid, image_data_id, "y_pzt_offset", t 
sd.y_pzt_offset=t 
ncdf_attget, cdfid, image_data_id, "initial_lambda", t 
sd.initial_lambda=t 
ncdf_attget, cdfid, image_data_id, "final_lambda", t 
sd.final_lambda=t 
ncdf_attget, cdfid, image_data_id, "sgm_step_size", t 
sd.sgm_step_size=t 
ncdf_attget, cdfid, image_data_id, "dx_dl", t 
sd.dx_dl=t 
ncdf_attget, cdfid, image_data_id, "dy_dl", t 
sd.dy_dl=t 
ncdf_attget, cdfid, image_data_id, "dz_de", t 
sd.dz_de=t 
 
sd_len=n_tags(sd,/length) 
user_buffer=bytarr(sd_len) 
do_copy_bytes = 1 
IF keyword_set(nocopybytes) THEN BEGIN 
    do_copy_bytes = 0 
ENDIF 
osname = strupcase(strmid(!version.os,0,3)) 
IF (osname NE 'VAX') THEN BEGIN 
    do_copy_bytes = 0 
ENDIF 
if (do_copy_bytes EQ 1) then begin 
    copy_bytes,sd_len,sd,user_buffer 
endif 
 
if (not keyword_set(header_only)) then begin 
    ncdf_varget, cdfid, image_data_id, image_data 
endif 
ncdf_varget, cdfid, data_title_id, data_title 
; ncdf_varget, cdfid, x_dist_id, x_dist 
; ncdf_varget, cdfid, y_dist_id, y_dist 
 
; ------------------ Kluge to replace bad points at start in ALS data 
; ---- aph (15-May-99) 
;image_data(*,0,*) = image_data(*,1,*)        ; REMOVED 20-may-99 IS THIS THE BUG  - YES !! 
 
x_dist = findgen(n_cols)/float((n_cols-1)>1)*(x_stop-x_start) + x_start 
y_dist = findgen(n_rows)/float((n_rows-1)>1)*(y_stop-y_start) + y_start 
 
; -------- change to relative scale (aph 9-sep-99) 
;x_stop = x_start - x_stop 
;y_stop = y_start - y_stop 
;x_start = 0.0 
;y_start = 0.0 
 
ncdf_close, cdfid 
 
if (not keyword_set(header_only)) then begin 
    khz=float(sd.clock_frequency)*float(image_data(*,*,0)) / $ 
        float(image_data(*,*,1)) 
endif 
 
bailout: 
return 
end 
 
