; Copyright (c) 1998-2008 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	GET_NUM
;
;LAST CHANGED: ----------------------------------- 01-Jun-08
;
;PURPOSE:
;	This procedure is a widget that displays the current value
; of a parameter (if defined) and then allows user to input a replacement value
; A <cr> (enter) will retain the same value
;
;CATEGORY:
;	AXIS: utility (can run stand alone)
;
;CALLING SEQUENCE:
;	Result = GET_NUM(Prompt = prompt, Val = value, group = Axis_ID))
;
;CALLED FROM AXIS:
;  many places
;
;ROUTINES
;	NUM_EVENT, Event - event processing
;	GET_NUM - widget
;
;INPUTS: none
;
;KEYWORDS:
;       VAL = current (default) value
;   	PROMPT = prompt to user
;		GROUP = Widget_Id of group leader (must be set to force modal; Axis_ID is name for axis_c)
;
;OUTPUTS:
;       The function returns a FLOAT value which is either :
;		the existing value (user hits <enter>)
;		or the first number in the string the user types
;
;COMMON BLOCKS:
;       TXTCOM (internal to get_num)
;
;SIDE EFFECTS:
;	A window is created/destroyed.
;
; DESCRIPTION:
;       This routine allows user to provide  a numerical value
;		If the top level group ID is supplied, the function widget is
;		put into modal mode (stays on top until user completes input; disables other functions of AXIS)
;
; EXAMPLES:
;       new_value = get_num(prompt='New value',val=current_value, group = axis_id)
;
; DEVELOPMENT NOTES:
;		should autosense if AXIS is the caller to avoid having to
;		explicitly provide the group ID
;
; MODIFICATION HISTORY:
; (20-jun-97 aph) first written
; (05-jun-98 aph) made function return a scalar NOT A 1-element array.
; (07-jun-99 aph) add separate prompt display; use IDL 5.2 modal convention; proper docs
; (27-feb-00 aph) AXIS standard documentation
; (09-sep-02 aph) format displayed number
; (01-Jun-08 aph) fix up documentation to be correct on 'val' and 'Axis_ID'
;-

PRO NUM_Event, Event
Common TXTCOM, text

WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev

CASE Ev OF
  'number': BEGIN
	   	 WIDGET_CONTROL, Event.Id, GET_VALUE = text
	   	 WIDGET_CONTROL, Event.Top, /DESTROY
     END
       ELSE: message, 'Invalid event call in Get_Num'
ENDCASE
END


FUNCTION get_num, GROUP=Group, VAL=val, PROMPT = prompt
Common TXTCOM, text

modal_val=1
IF N_ELEMENTS(Group) EQ 0 THEN begin
;  	test_valid = widget_event(AXIS, bad_id=bad_id) ;, FIND_BY_UNAME = 'AXIS')
;  	print, 'test_valid',test_valid
;	if group EQ 0 then				; attempt to auto-test if in AXIS - no go yet
group=0
modal_val=0
ENDIF

junk   = { CW_PDMENU_S, flags:0, name:'' }


NUM = WIDGET_BASE(GROUP_LEADER=Group, $
  ROW=2, $
  MAP=1, $
  modal = modal_val, $
  TITLE='get_num', $
  UVALUE='NUM')

prompt_text = 'input a number'
if keyword_set(prompt) then prompt_text = prompt

LABEL2 = WIDGET_LABEL( NUM, $
;      DYNAMIC_RESIZE=1, $
      UVALUE='prompt', $
      VALUE=prompt_text)

num_text = ''
IF KEYWORD_SET(val) THEN begin
	if val(0) - fix(val(0)) NE 0 then begin
		num_text = strcompress(string(val(0),format='(G11.4)'))
	endif else num_text = strcompress(string(fix(val(0))))
	if val(0) EQ 0 then num_text = ' 0'
ENDIF
text = num_text

TEXT2 = WIDGET_TEXT( NUM,VALUE=num_text, $
  EDITABLE=1, $
  UVALUE='number', $
  YSIZE=1)

WIDGET_CONTROL, NUM, /REALIZE
WIDGET_CONTROL, TEXT2, /INPUT_FOCUS
XMANAGER, 'NUM', NUM
tval = float(text)
val = float(0)
val = tval(0)
Return, val
END
