; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_XYDIS 
; 
;LAST CHANGED: ----------------------------------- 01-jan-00 
; 
;PURPOSE: 
;	This procedure modifies (x,y) pixel size based on user-defined conversion 
; 
;CATEGORY: 
;	AXIS: image utility 
; 
;CALLING SEQUENCE: 
;	AX_XYDIS 
; 
;CALLED FROM AXIS: 
;	Images->Distort XY scale 
; 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	modified image is written to buffer 0 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;MODIFICATION HISTORY: 
; (fall-97 aph) - first wrote for Mephisto data 
; (14-jun-98 aph) axis_com 
; (08-jun-99 aph) add group call to get_num 
; (14-dec-99 aph) get correct (x,y) values 
; (25-dec-99 aph) interpolate to square pixels 
; (01-jan-00 aph) AXIS standard documentation 
;- 
PRO ax_xydis 
@axis_com
on_error,2 
 
;   ******************** Warp X versus Y pixel size  of image  ********* 
   HANDLE_VALUE, Data(CurBuf), tmp 
   IF n_tags(tmp) NE 0 THEN BEGIN 
      if tmp.t EQ '2d' then begin         ; ONLY for images 
        SetGraf, 'MainImg' 
        nx = n_elements(tmp.x) 
		pix_siz = fix(1000.*abs(tmp.x(nx-1) - tmp.x(0))/nx)   ; save original pixel size for default mesh 
   		xfactor = get_num(prompt='X-axis factor', val=1.0, group = axis_id) 
   		yfactor = get_num(prompt='Y-axis factor', val=0.8, group = axis_id) 
   		tmp.x = tmp.x * xfactor 
 		tmp.y = tmp.y * yfactor 
 		xmin = min(tmp.x, max = xmax)  & xr = xmax - xmin 
 		ymin = min(tmp.y, max = ymax)  & yr = ymax - ymin 
 		xsz = n_elements(tmp.x) 
 		ysz = n_elements(tmp.y) 
 		if xr gt yr then begin  ; shrink x-range to match y-range 
			nysz = fix(yfactor*ysz) 
 			ty = congrid(tmp.y,nysz) 
 			yxtra = (ysz-nysz)/2 &  tyl = fltarr(yxtra) 
			yslope = (ymax-ymin)/nysz 
 			tyl = yslope*(tyl - yxtra) + ymin 
            tyh = fltarr(yxtra) 
 			tyh = yslope*tyh + ymax 
 			for i = 0, yxtra-1 do tmp.y(i) = tyl(i)        ; expand tmp.x 
 			tmp.y(yxtra: yxtra + nysz - 1) = ty 
 			for i = 0, yxtra-1 do tmp.y(i+yxtra+nysz) = tyh(i) 
 			expand,tmp.d, xsz, nysz, td                   ; expand image 
 			for i = 0, yxtra-1 do tmp.d(*,i) = tmp.d(*,0) 
 			tmpdh = tmp.d(*,ysz-1)						; preserve last line 
 			tmp.d(*,yxtra:yxtra+nysz-1) = td 
 			for i = 0, yxtra-1 do  tmp.d(*,i+yxtra+nysz) = tmpdh 
 		endif 
 		if xr lt yr then begin 
 			nxsz = fix(xfactor*xsz) 
 			tx = congrid(tmp.x,nxsz) 
 			xtra = (xsz-nxsz)/2 &  txl = fltarr(xtra) 
			xslope = (xmax-xmin)/nxsz 
 			txl = xslope*(txl - xtra) + xmin 
            txh = fltarr(xtra) 
 			txh = xslope*txh + xmax 
 			for i = 0, xtra-1 do tmp.x(i) = txl(i)        ; expand tmp.x 
 			tmp.x(xtra: xtra + nxsz - 1) = tx 
 			for i = 0, xtra-1 do tmp.x(i+xtra+nxsz) = txh(i) 
 			expand,tmp.d, nxsz, ysz, td                   ; expand image 
 			for i = 0, xtra-1 do tmp.d(i,*) = tmp.d(0,*) 
 			tmpdh = tmp.d(xsz-1,*)						; preserve last row 
 			tmp.d(xtra:xtra+nxsz-1,*) = td 
 			for i = 0, xtra-1 do  tmp.d(i+xtra+nxsz,*) = tmpdh 
 		endif 
 
; ------------ interpolate to a standard mesh size --------------- 
		pix_siz = 0.001*get_num(Prompt='Pixels (nm)',val = pix_siz, group = axis_id) 
		nx = fix(abs(tmp.x(n_elements(tmp.x)-1) - tmp.x(0)) /pix_siz) 
		ny = fix(abs(tmp.y(n_elements(tmp.y)-1) - tmp.y(0)) /pix_siz) 
		print, 'Congrid cut_data to ', nx, ny 
		xn = congrid(tmp.x,nx,/interp) 
		yn = congrid(tmp.y,ny,/interp) 
		dn = congrid(tmp.d,nx,ny,/interp) 
		tmp = create_struct('t','2d','x',xn,'y',yn,'d',dn, $ 
			'xl',tmp.xl,'yl',tmp.yl,'dl',tmp.dl) 
   		tmp.dl = 'xyF ' + tmp.dl 
 		print, ' Image distorted: X * ', xfactor, ' Y * ', yfactor 
    	CurBuf = 0 
   		HANDLE_VALUE, Data(CurBuf), tmp, /set 
   		Label(CurBuf) = tmp.dl 
   		PlotBuf,CurBuf 
   		WIDGET_CONTROL, Uprompt, $ 
   		   SET_VALUE='Distort-XY: X * ' + STRCOMPRESS(string(xfactor)) + ' Y * ' + STRCOMPRESS(string(yfactor)) 
   	  endif else WIDGET_CONTROL, Uprompt, SET_VALUE='distort-XY: only for images' 
   ENDIF 
END