; Copyright (c) 1998-2010 J. Stewart-Ornstein &  A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_AA_HEADER.PRO
;
;LAST CHANGED: ----------------------------------- 	19-Jul-10
;
; PURPOSE:
;	This function reads the header for a list of reference spectra datafiles
;
; CATEGORY:
;	Utility; part of XSpecSim, spectral simulator package
;
; CALLING SEQUENCE:
;	Result = READ_AA_HEADER(FILE=FILE)
;
; INPUTS: none
;
; KEYWORDS:
;	FILE	file name
;
; OUTPUTS: none
;
;COMMON BLOCKS:
;	@XSpecSim_Com		X-SpecSim common block
;
;
; MODIFICATION HISTORY:
; (28-feb-07 jso) first version
; (18-Jul-10 aph) AXIS standard header added; XSpecSim_com added
;-


Function read_AA_header, file=file
@XSpecSim_Com

if not keyword_set(file) then begin
  fltr='*.aah'
  file=pickfile2(/Write, FILTER=fltr, /LPATH)
endif

if strlen(file) GT 0 then begin
  	openr, iunit, file, /get_lun
  	test=''
  	j=long(0)
  	ans=strarr(1000)
	readf, iunit, test
	while not eof(iunit) do begin
		readf, iunit, test
		test = strtrim(test,2)
		ans(j)=	test
		j=j+1
	endwhile
  	ans=ans(0:j-1)
  	close, iunit & free_lun, iunit
  	return, ans
endif
end