
;+
; This is the file SXM_READFILE.PRO
; It holds FUNCTION SXM_READFILE
; Reads in a file in netCDF format.  It returns 0 on error,
; and 1 on success.
;
; Modified 04-APR-1998 to read in "now_nm"!!!
;-

FUNCTION Sxm_readfile, filename, error_message, $
                       header_only=header_only

@sxm_common
@sxm_acommon
@bsif_common

svec = size(sxm_par)
IF ((svec(0) EQ 0) AND (svec(1) EQ 0)) THEN BEGIN
    sxm_ipar
ENDIF

;find_the_file = findfile(filename)
;IF (find_the_file(0) EQ '') THEN BEGIN
IF (sxm_fileexists(filename, /nofindfile) EQ 0) THEN BEGIN
    error_message = 'File "'+filename+'" not found.'
    return, 0
ENDIF

; Open the file to be read
cdfid = ncdf_open(filename, /NOWRITE)

; Retrieve global attributes
ncdf_inq = ncdf_inquire( cdfid )
IF (ncdf_inq.ngatts LT 2) THEN BEGIN
    error_message = 'Not a SXM netCDF file! (<2 global attributes)'
    return, 0
ENDIF

ncdf_attget, cdfid, /GLOBAL, 'title', image_title
long_val = long(0)
ncdf_attget, cdfid, /GLOBAL, 'sxm_netcdf_version', long_val
sxm_par.filever_num = long_val
IF ((sxm_par.filever_num LT 1) OR (sxm_par.filever_num GT 2)) THEN BEGIN
    error_message = 'Unknown SXM file version '+$
      strtrim(string(sxm_par.filever_num), 2)
    return, 0
ENDIF

; Set up dimensions
ncdf_diminq, cdfid, 0, dummy, n_cols
ncdf_diminq, cdfid, 1, dummy, n_rows
ncdf_diminq, cdfid, 2, dummy, n_data
ncdf_diminq, cdfid, 3, dummy, n_chars
ncdf_diminq, cdfid, 4, dummy, n_pointlist
ncdf_diminq, cdfid, 5, dummy, n_adc_channels
ncdf_diminq, cdfid, 6, dummy, n_scaler_channels
ncdf_diminq, cdfid, 7, dummy, n_scaler_divideby
ncdf_diminq, cdfid, 8, dummy, n_channels

image_data_id = ncdf_varid(cdfid, 'image_data')
data_title_id = ncdf_varid(cdfid, 'data_title')
point_nameb_id = ncdf_varid(cdfid, 'point_nameb')
point_xyb_id = ncdf_varid( cdfid, 'point_xyb')
adc_channels_id = ncdf_varid( cdfid, 'adc_channels_nameb')
scaler_channels_id = ncdf_varid( cdfid, 'scaler_channels_nameb')
scaler_divideby_id = ncdf_varid( cdfid, 'scaler_divideby')
scanline_channels_id = ncdf_varid( cdfid, 'scanline_channels')
other_pixel_channels_id = ncdf_varid( cdfid, 'other_pixel_channels')

; Retrieve BSIF information
ncdf_attget, cdfid, image_data_id, 'x_normal', x_normal
ncdf_attget, cdfid, image_data_id, 'y_normal', y_normal
ncdf_attget, cdfid, image_data_id, 'rotated', rotated
ncdf_attget, cdfid, image_data_id, 'x_start', x_start
ncdf_attget, cdfid, image_data_id, 'x_stop', x_stop
ncdf_attget, cdfid, image_data_id, 'y_start', y_start
ncdf_attget, cdfid, image_data_id, 'y_stop', y_stop
ncdf_attget, cdfid, image_data_id, 'x_title', x_title
ncdf_attget, cdfid, image_data_id, 'y_title', y_title

; Save attributes for sxm_par stuff
ncdf_attget, cdfid, image_data_id, 'main_data_channel', result
sxm_par.main_data_channel = result
ncdf_attget, cdfid, image_data_id, 'clock_data_channel', result
sxm_par.clock_data_channel = result
ncdf_attget, cdfid, image_data_id, 'photodiode_channel', result
sxm_par.photodiode_channel = result
ncdf_attget, cdfid, image_data_id, 'xfast', result
sxm_par.xfast = result
ncdf_attget, cdfid, image_data_id, 'bidirectional', result
sxm_par.bidirectional = result
ncdf_attget, cdfid, image_data_id, 'shutopen', result
sxm_par.shutopen = result
ncdf_attget, cdfid, image_data_id, 'prescan_pixels', result
sxm_par.prescan_pixels = result
ncdf_attget, cdfid, image_data_id, 'mot_baserate', result
sxm_par.mot_baserate = result
ncdf_attget, cdfid, image_data_id, 'mot_accelmsec', result
sxm_par.mot_accelmsec = result
ncdf_attget, cdfid, image_data_id, 'xy_umstep', result
sxm_par.xy_umstep = result
ncdf_attget, cdfid, image_data_id, 'yz_umstep', result
sxm_par.yz_umstep = result
ncdf_attget, cdfid, image_data_id, 'msec_dwell', result
sxm_par.msec_dwell = result
ncdf_attget, cdfid, image_data_id, 'x_center_um', result
sxm_par.x_center_um = result
ncdf_attget, cdfid, image_data_id, 'y_center_um', result
sxm_par.y_center_um = result
ncdf_attget, cdfid, image_data_id, 'z_center_um', result
sxm_par.z_center_um = result
IF (sxm_par.filever_num GT 1) THEN BEGIN 
    ncdf_attget, cdfid, image_data_id, 'now_nm', result
    sxm_par.now_nm = result
ENDIF 
ncdf_attget, cdfid, image_data_id, 'start_nm', result
sxm_par.start_nm = result
ncdf_attget, cdfid, image_data_id, 'end_nm', result
sxm_par.end_nm = result
ncdf_attget, cdfid, image_data_id, 'xum_per_zum', result
sxm_par.xum_per_zum = result
ncdf_attget, cdfid, image_data_id, 'yum_per_zum', result
sxm_par.yum_per_zum = result

ncdf_attget, cdfid, image_data_id, 'pmt_voltage', result
sxm_par.pmt_voltage = result
ncdf_attget, cdfid, image_data_id, 'holder_start_temperature', result
sxm_par.holder_start_temperature = result
ncdf_attget, cdfid, image_data_id, 'holder_end_temperature', result
sxm_par.holder_end_temperature = result
ncdf_attget, cdfid, image_data_id, 'ac_start_temperature', result
sxm_par.ac_start_temperature = result
ncdf_attget, cdfid, image_data_id, 'ac_end_temperature', result
sxm_par.ac_end_temperature = result

ncdf_attget, cdfid, image_data_id, 'zp_d_um', result
sxm_par.zp_d_um = result
ncdf_attget, cdfid, image_data_id, 'zp_delta_nm', result
sxm_par.zp_delta_nm = result
ncdf_attget, cdfid, image_data_id, 'zp_stop_um', result
sxm_par.zp_stop_um = result
ncdf_attget, cdfid, image_data_id, 'zp_osa_um', result
sxm_par.zp_osa_um = result
ncdf_attget, cdfid, image_data_id, 'undulator_mm', result
sxm_par.undulator_mm = result
ncdf_attget, cdfid, image_data_id, 'ring_gev', result
sxm_par.ring_gev = result
ncdf_attget, cdfid, image_data_id, 'ring_ma', result
sxm_par.ring_ma = result
ncdf_attget, cdfid, image_data_id, 'entrance_slit_um', result
sxm_par.entrance_slit_um = result
ncdf_attget, cdfid, image_data_id, 'exit_slit_um', result
sxm_par.exit_slit_um = result
ncdf_attget, cdfid, image_data_id, 'disp_min', result
sxm_par.disp_min = result
ncdf_attget, cdfid, image_data_id, 'disp_max', result
sxm_par.disp_max = result
ncdf_attget, cdfid, image_data_id, 'disp_gamma', result
sxm_par.disp_gamma = result
ncdf_attget, cdfid, image_data_id, 'point_maxnum', result
sxm_par.point_maxnum = result
ncdf_attget, cdfid, image_data_id, 'scanmode', result
sxm_par.scanmode = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'beamline', result
sxm_par.beamline = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'sample', result
sxm_par.sample = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'operator', result
sxm_par.operator = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'comments1', result
sxm_par.comments1 = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'comments2', result
sxm_par.comments2 = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'dirname', result
sxm_par.dirname = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'progver_name', result
sxm_par.progver_name = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'systime', result
sxm_par.systime = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'zp_name', result
sxm_par.zp_name = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'disp_mode', result
sxm_par.disp_mode = sxm_strclean(result, /to_bytearray)
ncdf_attget, cdfid, image_data_id, 'filename', result
sxm_par.filename = sxm_strclean(result, /to_bytearray)

IF (NOT keyword_set(header_only)) THEN BEGIN
    ncdf_varget, cdfid, image_data_id, image_data
ENDIF
ncdf_varget, cdfid, data_title_id, data_title
ncdf_varget, cdfid, point_nameb_id, result
sxm_par.point_nameb = result
ncdf_varget, cdfid, point_xyb_id, result
sxm_par.point_xyb = result
ncdf_varget, cdfid, adc_channels_id, result
sxm_par.adc_channels_nameb = result
ncdf_varget, cdfid, scaler_channels_id, result
sxm_par.scaler_channels_nameb = result
ncdf_varget, cdfid, scaler_divideby_id, result
sxm_par.scaler_divideby = result
ncdf_varget, cdfid, scanline_channels_id, result
sxm_par.scanline_channels = result
ncdf_varget, cdfid, other_pixel_channels_id, result
sxm_par.other_pixel_channels = result

; Note that we define positions according to the
; centers of pixels.  Therefore x_start is the center of
; the leftmost pixel, and x_stop is the center of the rightmost
; pixel.  That affects our definition of xy_umstep and x_dist,
; and yz_umstep and y_dist
sxm_par.xy_pix = n_cols
sxm_par.yz_pix = n_rows
sxm_par.n_data = n_data
IF (strupcase(string(sxm_par.scanmode)) EQ 'SPEC') THEN BEGIN
    x_dist = sxm_par.start_nm +$
      (sxm_par.end_nm-sxm_par.start_nm)*findgen(n_cols)/$
      float(n_cols-1)
    y_dist = y_start
ENDIF ELSE BEGIN
    x_dist = x_stop+findgen(n_cols-1)*sxm_par.xy_umstep
    y_dist = y_start+findgen(n_rows-1)*sxm_par.yz_umstep
ENDELSE

; Close file
ncdf_close, cdfid

return, 1
END




