; Copyright (c) 1998-2005 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_TOMO
;
;LAST CHANGED: ----------------------------------- 13-Dec-05
;
; PURPOSE:
;	This Sript processes a set of folders containing stacks for tomography read-in
;
; CATEGORY:
;	Input / output utilty; stand alone
;
; CALLING SEQUENCE:
;	Result =
;
; INPUTS:
; 	FILE	list of folders to process
;
; OUTPUTS:
;	folder with selected files
;
; MODIFICATION HISTORY:
; (13-dec-05 aph) adapt to non-axis and non-interactive use (for tomography)
;-

Function ax_tomo_read, file=file

; --------- list of folders
list_filename=pickfile2(title = "List of folders")
get_lun,lun
openr,lun,list_filename
sl_path = ''
readf, lun, sl_path		; check if first line is only a path
t = ax_name(sl_path)
filebase=t(0)+t(1)
; ------ determine number of files to process
keep_going = 1
got_started = 0
;if strlen(t(1)) EQ 0 or  strlen(t(2)) EQ 0 then begin
while ~ EOF(lun) do begin
    this_filename = ''
    readf,lun,this_filename
    if (got_started eq 0) then begin
; ------ OK the first line is a path .... but is it the right one ? !!!!
       filename_list = [this_filename]
       got_started = 1
    endif else begin
        filename_list = [filename_list,this_filename]
    endelse
 endwhile
nfiles=n_elements(filename_list)
close,lun  &  free_lun,lun
; print, filename_list
; return, filename_list

; select items to read
t=dialog_message('single image? (Yes; No=map)', /question, title='what to read')
if t EQ 'Yes' then item = 'image' else item = 'map'

; ---------- read a map for each angle
CASE item OF

'image': BEGIN
; ------------- read a single image for each angle
img_num=4
img_num=get_num(prompt='image number', val = img_num)
sep= ax_sep()
flag='_I' +strtrim(string(fix(img_num)),2) + '_'
print, 'flag: ', flag
;out_filebase = sl_path + sep + 'tomo_list.lst'
for i = 0, nfiles-1 do begin
	file = sl_path + '51211' + filename_list(i) + sep + filename_list(i) + '.hdr'
;	print, file
	tmp=read_sdf(file=file, channel=1, /one_image )
	zero ='000'
	t_num = strtrim(strcompress(string(i)),2)
	strput, zero, t_num, 3-strlen(t_num)
	file_out = sl_path + filename_list(i) + flag + zero + '.nc'
	print, 'file_out: ', file_out
	file=sav_nsls(file=file_out, tmp)
endfor
return, file
END


'map': BEGIN

; define parameters
img_bgnd = 0
img_signal = 1
img_bgnd = get_num(prompt='image number for BACKGROUND', val = img_bgnd)
img_signal = get_num(prompt='image number for BACKGROUND', val = img_signal)

image_num=[img_bgnd,img_signal]

a=read_sdf(file=file, channel=1, /map , image_num=image_num)


END
ELSE:

ENDCASE

return, filename_list
END
