; This routine makes a movie out of a stack. 
; It does not attempt to do any image alignment. 
; 
 
PRO Stack_movie, list_filename, $ 
                 zoom=zoom, text_height=text_height, $ 
                 gifmovie_filename=gifmovie_filename, $ 
                 spectrum_nc_filename=spectrum_nc_filename, $ 
                 help=help 
 
@bsif_com
 
IF keyword_set(help) THEN BEGIN 
    print,'stack_movie,[list_filename],[zoom=,text_height=,]' 
    print,'            [gifmovie_filename=] to make a GIF movie' 
    print,'            [spectrum_nc_filename=] to also show a spectrum' 
    print,'  where [list_filename] is an optional list of files' 
    return 
ENDIF 
 
IF (NOT keyword_set(zoom)) THEN zoom = 2 
IF (NOT keyword_set(text_height)) THEN text_height = 12 
 
osname=strupcase(strmid(!version.os,0,3)) 
IF keyword_set(gifmovie_filename) THEN BEGIN 
    dotpos = strpos( gifmovie_filename, '.') 
    IF (dotpos EQ (-1)) THEN BEGIN 
        header = gifmovie_filename 
    ENDIF ELSE BEGIN 
        header = strmid(gifmovie_filename,0,dotpos) 
    ENDELSE 
    IF ((strlen(header) GT 8) and (osname EQ 'WIN')) THEN BEGIN 
        print,'MultiGIF on Windows cannot create long filenames' 
        return 
    ENDIF 
ENDIF 
 
text_height = fix(text_height) 
text_ysize = fix(2.5*text_height) 
text_yoff1 = fix(0.5*text_height) 
text_yoff2 = fix(1.5*text_height) 
 
stack_readlist, list_filename, filename_list 
 
n_files = n_elements(filename_list) 
 
IF (n_files LT 2) THEN BEGIN 
    print,'No files in list for making a movie!' 
    return 
ENDIF 
 
IF keyword_set(spectrum_nc_filename) THEN BEGIN 
    read_stxm,spectrum_nc_filename,sd,khz 
    spectrum_ev = 12398.52/x_dist 
    spectrum_khz = khz 
    print,'Got spectrum from file "'+spectrum_nc_filename+'"' 
    plot_ypix = 128 
ENDIF ELSE BEGIN 
    plot_ypix = 0 
ENDELSE 
 
FOR i_file = 0, (n_elements(filename_list)-1) DO BEGIN 
    read_stxm, filename_list(i_file), sd, khz,/nocopybytes 
    this_ev = 12398.52/sd.wavelength 
    file_ev_string = $ 
      strtrim(string(this_ev, format = '(f10.2)'), 2)+$ 
      ' eV: '+filename_list(i_file) 
    IF (i_file EQ 0) THEN BEGIN 
        wxsize = n_cols*zoom 
        wysize = n_rows*zoom+text_ysize+plot_ypix 
        plot_position = [0,0,wxsize,plot_ypix] 
        window, 0, xsize = wxsize, ysize=wysize 
        vec = byte(indgen(!D.table_size)) 
        tvlct, vec, vec, vec 
 
        pixel_size = abs(x_stop-x_start)/float(n_cols) 
; print, 'pixel size (um) = ', pixel_size 
; print, 'No of colors = ', !D.table_size 
        bar_length = (0.25*n_cols*pixel_size)             ; removed fix (aph 29-jun-98) 
        bar_pixels = fix(0.5+n_cols*zoom*bar_length/float(n_cols*pixel_size)) 
        bar_string = strtrim(string(bar_length, $ 
                                    format = '(f10.1)'), 2)+' microns' 
        bar = bytarr(bar_pixels, fix(0.75*text_height))+!D.table_size-1 
        bar_norm_xoff1 = float(text_height)/float(wxsize) 
        bar_norm_yoff1 = float(text_yoff1+plot_ypix)/float(wysize) 
        bar_norm_xoff2 = float(2*text_height+bar_pixels)/float(wxsize) 
        bar_norm_yoff2 = float(text_yoff2+plot_ypix)/float(wysize) 
 
        xinteranimate, set = [wxsize, wysize, n_files] 
    ENDIF 
 
    erase 
    tv, rebin(bytscl(khz, top = !D.table_size-1), n_cols*zoom, n_rows*zoom), $ 
      0, text_ysize+plot_ypix 
    tv, bar, text_height, text_yoff2+plot_ypix 
    xyouts, bar_norm_xoff1, bar_norm_yoff1, /norm, file_ev_string 
    xyouts, bar_norm_xoff2, bar_norm_yoff2, /norm, bar_string 
 
    IF keyword_set(spectrum_nc_filename) THEN BEGIN 
        plot,spectrum_ev,spectrum_khz,$ 
            xtitle='eV',position=plot_position,/device,$ 
            /noerase,ystyle=13,yrange=[0.,max(spectrum_khz)],xstyle=8 
        plots,[this_ev,this_ev],[!y.crange(0),!y.crange(1)],/data,$ 
            color=fix(0.6*!d.table_size),thick=2 
    ENDIF 
 
    xinteranimate, frame = (i_file), $ 
      window = [0, 0, 0, wxsize, wysize] 
 
    IF keyword_set(gifmovie_filename) THEN BEGIN 
        IF (i_file EQ 0) THEN BEGIN 
          get_lun,lun 
          openw,lun,'tempgif.tmp' 
        ENDIF 
 
        IF (i_file LT 10) THEN BEGIN 
            gifframe_filename = 'temp000'+strtrim(string(i_file),2)+'.gif' 
        ENDIF ELSE IF (i_file LT 100) THEN BEGIN 
            gifframe_filename = 'temp00'+strtrim(string(i_file),2)+'.gif' 
        ENDIF ELSE IF (i_file LT 1000) THEN BEGIN 
            gifframe_filename = 'temp0'+strtrim(string(i_file),2)+'.gif' 
        ENDIF ELSE BEGIN 
            gifframe_filename = 'temp'+strtrim(string(i_file),2)+'.gif' 
        ENDELSE 
 
        bytimg=tvrd(0,0,wxsize,wysize) 
        write_gif,gifframe_filename,bytimg,vec,vec,vec 
        printf,lun,gifframe_filename 
    ENDIF 
 
ENDFOR 
 
IF keyword_set(gifmovie_filename) THEN BEGIN 
    close,lun 
    free_lun,lun 
 
    command='multigif -n 0 -o '+gifmovie_filename+' @tempgif.tmp' 
    result='' 
    print,'Command: "'+command+'"' 
    spawn,command,result 
    print,'  Result: "'+result+'"' 
    osname=strupcase(strmid(!version.os,0,3)) 
    IF (osname EQ 'VMS') THEN BEGIN 
        command1='del temp*.gif;*' 
        command2='del tempgif.tmp;*' 
    ENDIF ELSE IF (osname EQ 'WIN') THEN BEGIN 
        command1 = 'del temp*.gif' 
        command2 = 'del tempgif.tmp' 
    ENDIF ELSE BEGIN 
        command1 = 'rm temp*.gif' 
        command2 = 'rm tempgif.tmp' 
    ENDELSE 
    print,'Command: "'+command1+'"' 
    spawn,command1,result 
    print,'  Result: "'+result+'"' 
    print,'Command: "'+command2+'"' 
    spawn,command2,result 
    print,'  Result: "'+result+'"' 
 
    print,'Created GIF movie "'+gifmovie_filename+'"' 
ENDIF 
 
;; start out with something less than full speed 
xinteranimate, 20. 
 
return 
END 
 
