; Copyright (c) 1998-2011 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		RANDOMFILE.PRO
;
;LAST CHANGED: ----------------------------------- 	03-Feb-11
;
; PURPOSE:
;	This  function returns a random file name which is unique
;
; CATEGORY:
;	stand alone utility
;
; CALLING SEQUENCE:

;	Result = RANDOMFILE()
;
; INPUTS: none
;
; KEYWORDS: none
;
; OUTPUTS: returns a unique file name
;
; COMMON BLOCKS:
;	RANDOMFILE_COMMON
;
; MODIFICATION HISTORY:
; (01-Jan-93 cjj) first written
; (18-Jul-10 aph) AXIS standard header added
;-


FUNCTION randomfile

common RANDOMFILE_COMMON, randomfile_seed

leader='temp'
IF (strupcase(strmid(!version.os,0,3)) EQ 'VMS') THEN BEGIN
    trailer='.tmp;1'
ENDIF ELSE BEGIN
    trailer='.tmp'
ENDELSE

filename=leader+strtrim(string(fix(9999.*randomu(randomfile_seed)), $
                               format='(i)'),2)+trailer
it_exists=findfile(filename)
WHILE (it_exists(0) NE '') DO BEGIN
    num=fix(9999.*randomu(randomfile_seed))
    filename=leader+strtrim(string(num,format='(i)'),2)+trailer
    it_exists=findfile(filename)
ENDWHILE

return,filename

END
