; Copyright (c) 2007 A. Scholl  All rights reserved
;+
;NAME:
;		WRITE_P3B
;
;LAST CHANGED: ----------------------------------- 	20-Jan-07
;
; PURPOSE:
;	This function writes a 2-d array as an ALS PEEM3 image
; (IDL windows binary with a structure defining microscope parameters)
;
; CATEGORY:
;	utility
;
; CALLING SEQUENCE:
;	Result =  WRITE_P3B, Filename, Data, TAGS = tags
;
; INPUTS:
;	Filename	name of file (ext = '*.p3b')
;	Data		2-d array with image
;
; KEYWORDS:
;	TAGS	predefined structure of microscope parameters
;
; OUTPUTS:
;	RESULT	ALS PEEM3 format data file
;
; COMMON BLOCKS: none
;
;
; MODIFICATION HISTORY:
; (20-Jan-07 aph) extracted from filetype_p3b.pro (20-jan-07 version of A. Scholl)
;-

pro Write_P3B, Filename, Data, TAGS = tags

	struct = SIZE(Data, /STRUCTURE)
	dims = struct.Dimensions
	pixtype = struct.Type
	if N_ELEMENTS(tags) gt 0 then begin
		ftags = CREATE_STRUCT('DimX', dims[0], 'DimY',  dims[1], 'PixType', pixtype, 'Data', data, tags)
	endif else begin
		ftags = CREATE_STRUCT('DimX', dims[0], 'DimY',  dims[1], 'PixType', pixtype, 'Data', data)
	endelse
	OPENW, Unit, Filename, /GET_LUN
	WriteTags, Unit, ftags
	CLOSE, Unit
	FREE_LUN, Unit

end