; Copyright (c) 1998-2011 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_IMG_DEL
;
;LAST CHANGED: ----------------------------------- 15-Dec-11
;
; PURPOSE:
;	This procedure replaces all pixels in a user-selected region
; by user-selected value (default is the meanof the whole image)
; If image is larger than the main window size or less than 1/2 of the main  window size
; the image is resized prior to the delete operation and then rescaled back to the oriignal size
;
; CATEGORY:
;	AXIS: image analysis
;
; CALLING SEQUENCE:
;	AX_IMG_DEL
;
;CALLED FROM AXIS:
;	->Images->Delete region

; INPUTS:
;	All input parameters are passed as keywords or through AXIS_COM
;
; KEYWORDS: none
;
; OUTPUTS:
;	Modified image placed in buffer 0.
;
; COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
; PROCEDURE:
;	Uses DefROI widget for felxible region of interest definition
;  If image is larger than the MainWid size (360*gr_scale) then a temporary image is generated
;   f rediced size using congrid  NOT rebin in order to handle non integer zooms
;  For congrid, the cubic=-0.5 option is used for greater accuarcy (see IDL HELP for congrid)
;
; RESTRICTIONS:
;	only executable from AXIS
;
; MODIFICATION HISTORY:
; (31-dec-99 aph) first written
; (03-Feb-11 aph) reduce size of large images prior to delete operation & re-scale after deletion
;         content was there but incorrect !
; (15-dec-11 aph) fix method for small and mid-sized images
;-

PRO ax_img_del

@axis_com
on_error,2

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
IF tmp.t NE '2d' THEN BEGIN
	axis_log, 'Image~Delete region: only for images'
	RETURN
ENDIF
img_zoom = 1
SetGraf, 'MainImg'
erase
loadct,ColTbl,/silent
ncol = n_elements(tmp.x) & nrow = n_elements(tmp.y)
img_size = max([ncol, nrow])
if img_size GT 360*gr_scale then begin
	img_zoom =  floor(img_size / 360*gr_scale) + 1  ;for images larger than 360*gr_scale
	text = '1/' + string(img_zoom, format='(I2)')
	axis_log, 'image rescaled by  ' + text  + ' before delete ROI'
	t_img = congrid(tmp.d, fix(ncol/img_zoom), fix(nrow/img_zoom), cubic = -0.5)
	tvscl, t_img
 	roi = cw_defroi(MainWid, image_size = [ncol/img_zoom, nrow/img_zoom])
	svec = size(roi)
	IF svec(0) EQ 0 then RETURN	; proceed only if roi is real region
	t = moment(tmp.d,/nan)
	replace = get_num(Prompt = 'replace with ',val = t(0) , group = axis_ID)
	t_img(roi) = replace
	tmp.d = congrid(t_img, ncol, nrow, cubic = -0.5)
endif
if img_size GE 160*gr_scale AND img_size LE 360*gr_scale then begin
    tvscl, tmp.d
    roi = cw_defroi(MainWid, image_size = [ncol,nrow])
	svec = size(roi)
	IF svec(0) EQ 0 then RETURN	; proceed only if roi is real region
	t = moment(tmp.d,/nan)
	replace = get_num(Prompt = 'replace with ',val = t(0) , group = axis_ID)
	tmp.d(roi)=replace
endif
if img_size LT 160*gr_scale then begin
    img_zoom =  floor(360*gr_scale / img_size)
    text = string(img_zoom, format='(I2)')
    axis_log, 'image rescaled by  ' + text  + ' before delete ROI generation'
    tvscl, rebin(tmp.d, img_zoom*ncol,img_zoom*nrow)
    roi = cw_defroi(MainWid, image_size = [ncol,nrow], zoom =[img_zoom, img_zoom])
	svec = size(roi)
	IF svec(0) EQ 0 then RETURN	; proceed only if roi is real region
	t = moment(tmp.d,/nan)
	replace = get_num(Prompt = 'replace with ',val = t(0) , group = axis_ID)
	tmp.d(roi)=replace
endif

ax_color
CurBuf = 0
tmp.dl =  tmp.dl + ' DR-M '
HANDLE_VALUE, Data(CurBuf), tmp, /set
PlotBuf, CurBuf
Label(CurBuf) = tmp.dl
END
