; Copyright (c) 1998-2014 A.P. Hitchcock   All rights reserved
;+
;NAME:
;	PARSESTRING.PRO
;
;LAST CHANGED: ----------------------------------- 23-Jul-14
;
;PURPOSE:
;	This function splits text string into constituent numbers

;CATEGORY:
;	STAND ALONE: utilities
;
;CALLING SEQUENCE:
;	Result = PARSESTRING(string)
;
;CALLED FROM AXIS:
;	many procedures
;
;ROUTINES
;	PARSESTRING	 splits text string into constituent numbers
;
; METHOD
; given s string, which is a tab, comma or space delimited list of #s,
; parsestring returns an array of numbers.
; if no numbers are found, or other error, returns 0
;
; you can distinguish the error from "0.0" using the size function,
; since the error condition is a scalar, not a vector
;
;COMMON BLOCKS: none
;
;-----------------
; FILE ROUTINES -- eli's text format
;-----------------
;file structure-
;line 0: number of items
;line 1: string=name of first item
;line 2: size(item)
;line 3: item, space-delimited
;line 4: string=name of next item
;
;MODIFICATION HISTORY:
; (25-may-99 aph) activated print option in textread1 to work with ascii read-in
; (26-feb-00 aph) AXIS standard documentation
; (11-Aug-09 aph) isolate from file.pro (each routine has its own name)
; (23-Jul-14 aph) add comma as a possible delimiter
;-
;
function parseString, string
;
on_Error,2
sa=strarr(500)
string=strtrim(string, 2) ;removes leading/trailing space
string=strcompress(string) ; tabs, multi-space-> space

; ----- convert comma's to spaces -------- (23-Jul-14 aph)
string = strjoin(strsplit(string,',',/extract),' ')

  ;count the number of items --> sa
 ; i=0
 ; cnt=0
 ; if strlen(string) ne 0 then begin
 ;   while(i ne -1) do begin
 ;     j=strpos(string, ' ', i)
 ;     if(j ne -1) then begin
 ;       sa(cnt)=strmid(string, i, j-i)
 ;       cnt=cnt+1
 ;       i=j+1
 ;     endif else begin
 ;       sa(cnt)=strmid(string, i, strlen(string)-i)
 ;       cnt=cnt+1
 ;       i=-1
 ;     endelse
 ;   endwhile
 ;   sa=sa(0:cnt-1)
 ; endif

  sa=str_sep(string, ' ')
  cnt=n_elements(sa)

  if(cnt gt 0) then begin
    fa=fltarr(cnt)
    error=0
;check that the first column is a number and then assume they all are
;    if isNumber(sa(0)) then reads,sa,fa else error=1
;check each item one at a time; if number, then copy to fa
    flt=0.0
    error=0
    for i=0,cnt-1 do begin
      if isNumber(sa(i)) eq 1 then begin
        reads,sa(i),flt
        fa(i)=flt
      endif else begin
        error=+1
      endelse
    endfor ;i
;
    if error then ans=0 else ans=fa
  endif else ans=0
  return,ans
end
