; Copyright (c) 1998-2003 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_PAR_LOAD
;
;LAST CHANGED: ----------------------------------- 04-jun-03
;
;PURPOSE:
;	This function reads path and file names of reference spectra used in
; stack  (ax_svd, stack_fit, cgo_fit), line (line_fit) and spectra ( ax_curvefit) fitting procedures
;
;CATEGORY:
;	STAND ALONE: utility
;
;CALLING SEQUENCE:
;	PARS = AX_PAR_LOAD (par_file)
;
;CALLED FROM AXIS:
;	stacks~maps~(ax_svd, stack_fit, cgo_fit); linescans~line fit; spectra~curve fit

;INPUTS:
;	PAR_FILE - name of parameter file
;
;KEYWORDS: none
;
;OUTPUTS:
;	PARS = structure (n = number of ref. spectra; names = names; files = filenames)
;          or 0 if there is an error in reading par file or locating files
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
;	Path is determined from par file. If files not foud, check if DefPath works, then ask user
;
;MODIFICATION HISTORY:
; (04-jun-03) first developed from duplicates in stack fitting routines
;-
FUNCTION ax_par_load, par_file
@axis_com
on_error,2

; -------- check that parameter file exists; if not - ask user
check = findfile(par_file)
if strlen(check(0)) EQ 0 then begin
		print, 'Did not find reference spectra parameter file ', par_file
		par_file = pickfile2(/read, title = ' Select fit parameter file', $
		      filter='*.par', /LPATH, DEFPATH=defpath)
		if strlen(par_file(0)) EQ 0 then return, 0
endif

openr, iunit, par_file, /get_lun
readf, iunit, ncomp
par_path = ''
readf, iunit, par_path
print, 'Reading ', string(ncomp,format='(i2)'), ' reference spectra files from ', par_path
comp_names = strarr(ncomp)
comp_files = strarr(ncomp)
bad_par_flag = 0
for i = 0,ncomp-1 do begin
	tn = ''
;	print, 'Reading info for component ',i
	readf, iunit, tn
	comp_names(i) = strtrim(string(tn),2)
	readf, iunit, tn
	comp_files(i)  = par_path+strtrim(string(tn),2)

; --------- CHECK IF PATH IS VALID
	check = findfile(comp_files(i))
	if strlen(check(0)) EQ 0 then begin
		bad_par_flag = 1
		bad_path = comp_files(i)
		tn = ax_name(bad_path)
		test_file = DefPath+tn(1)+ '.' + tn(2)
		print, 'Cannot find ', tn(1)+ '.' + tn(2), ' in folder ', tn(0)
		print, 'Checking for existence of ', test_file
		check2 = findfile(test_file)
		if strlen(check2(0)) NE 0 then begin
			comp_files(i) = test_file
		endif else begin
			tn = ax_name(comp_files(i))
			print, 'Cannot find file: ',tn(1)+ '.' + tn(2),'  in folder ', DefPath
 		 	test_file = pickfile2(title = ' Spectrum of component '+ comp_names(i), $
       			filter='*.txt', /LPATH, DEFPATH=defpath )
			if test_file EQ '' then return,0 else comp_files(i) = test_file  ; cancel at any time
		endelse
		tp = ax_name(test_file)		; replace par_path
		par_path = tp(0)
	endif
;	print, comp_names(i),' from file ', comp_files(i)
endfor
close, iunit   &   free_lun, iunit

; ------- rewrite parameter file if there were any errors ----------
if bad_par_flag EQ 1 then ax_par_save, par_file, ncomp, comp_names, comp_files

pars = {n: ncomp, names: comp_names, files: comp_files}
return, pars

END
