; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
; Copyright (c) 1995, ALS SpectroMicroscopy Facility, er, jdd
;+
;NAME:
;		READWIN.PRO
;
;LAST CHANGED: ----------------------------------- 21-Jul-14
;
; PURPOSE:
;	This function reads contents of WNUM graphics window
; into a bytscl array
;
; CATEGORY: graphics utility; standalone
;
; CALLING SEQUENCE:
;	RESULT = READWIN, WNUM
;
; INPUTS:
; WNUM	number of window to read (optional; current window is default)
;    wnum is specified either as number
;    or as a 5-element array [num, x0, y0, xwid, ywid] for a subset of the window
;
; KEYWORDS: none
;
; OUTPUTS: none
;
; COMMON BLOCKS: none
;
; MODIFICATION HISTORY:
; (29-dec-00 aph) isolated from window.pro; AXIS standard header added
; (21-Jul-14 aph) corrected header
;-

function READWIN, wnum

on_error, 2
owin=!d.window
if n_elements(wnum) eq 0 then wnum=!d.window
wset, wnum(0)
wshow, wnum(0)		;send to front if partially hidden
if n_elements(wnum) eq 1 then $
   im=tvrd() $
else $
   im=tvrd( wnum(1), wnum(2), wnum(3), wnum(4) )
wset, owin
wshow, owin
return, im
end
