; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_ORDER 
; 
;LAST CHANGED: ----------------------------------- 14-nov-00 
; 
;PURPOSE: 
;	This function forces image data in a structure 
; to adopt increasing (x,y) values 
; 
;CATEGORY: 
;	STAND ALONE: utility 
; 
;CALLING SEQUENCE: 
;	Result = AX_ORDER(structure) 
; 
;CALLED FROM AXIS: 
;	PlotBuf 
 
;INPUTS: 
;	s_in - AXIS 2d structure 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	Result = AXIS 2d structure with x, y values increasing 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;PROCEDURE: 
;	Image data is also reversed to preserve image position information. 
; 
;MODIFICATION HISTORY: 
; ( 6-jul-99 aph) first developed to get correct lineouts 
; (31-dec-99 aph) AXIS standard documentation 
; (14-nov-00 cgz) Replaced calls to GET_RANGE function with ecplicit MIN and MAX calls
;- 
 
FUNCTION ax_order, s_in 
@axis_com
on_error,2 
 
s = s_in 
IF n_tags(s) EQ 0 THEN RETURN, s 
IF s.t EQ '2d' THEN BEGIN 
;	xr = get_range(s.x)
;	yr = get_range(s.y) 
	xr = [min(s.x),max(s.x)] 
	yr = [min(s.y),max(s.y)] 
	if s.x(0) GT xr(0) then begin 
		s.x = reverse(s.x) 
		s.d = reverse(s.d) 
		print, 'x data reversed' 
	endif 
	if s.y(0) GT yr(0) then begin 
		s.y = reverse(s.y) 
		s.d = reverse(s.d,2) 
		print, 'y data reversed' 
	endif 
ENDIF 
return, s 
END 
