FUNCTION axis2000_config_dir

  COMMON axis2000_common, config_dir

  IF (N_ELEMENTS(config_dir) NE 1) THEN BEGIN

    ; Increment if author_readme_text is changed
    author_readme_version = 1

    author_readme_text = $
      ['This is the user configuration directory for', $
      'IDL progams written and supported by Adam Hitchcock', $
      '', $
      ' Adam Hitchcock', $
      ' BIMR, McMaster University', $
      ' Hamilton, ON, Canada L8S 4M1', $
      '', $
      ' aph@mcmaster.ca' ]

    ; Increment if app_readme_text is changed
    app_readme_version = 1

    app_readme_text = $
      ['This is the configuration directory for aXis2000']

    config_dir = APP_USER_DIR('aph', 'Adam Hitchcock', $
      'aXis2000', 'Analysis of X-ray Images and Spectra (aXis2000)', $
      app_readme_text, app_readme_version, $
      AUTHOR_README_TEXT=author_readme_text, $
      AUTHOR_README_VERSION=author_readme_version, $
      RESTRICT_APPVERSION='1.0', /RESTRICT_FAMILY)

  ENDIF

  RETURN, config_dir

END
