; Copyright (c) 2007 A. Scholl  All rights reserved
;+
;NAME:
;		WRITE_TAGS
;
;LAST CHANGED: ----------------------------------- 	20-Jan-07
;
; PURPOSE:
;	This function writes parameters as a structure in the AL SPEEM3 data format
;
; CATEGORY:
;	utility
;
; CALLING SEQUENCE:
;	Result =  WRITE_P3B, UNIT,  tags
;
; INPUTS:
;	Unit	open file unit number
;	Tags	parameters with associated Tag names (IDL structure)
;
; KEYWORDS: none
;
; OUTPUTS: adds tags to data file
;
; COMMON BLOCKS: none
;
;
; MODIFICATION HISTORY:
; (20-Jan-07 aph) extracted from filetype_p3b.pro (20-jan-07 version of A. Scholl)
;-

pro WriteTags, Unit, Tags

	tagnames = TAG_NAMES(Tags)
	WRITEU, Unit, N_ELEMENTS(tagnames)
	for i = 0, N_ELEMENTS(tagnames)-1 do begin
		len = STRLEN(tagnames[i])
		WRITEU, Unit, len
		WRITEU, Unit, tagnames[i]
		type = SIZE(Tags.(i), /TYPE)
		WRITEU, Unit, type
		if type eq 7 then WRITEU, Unit, STRLEN(Tags.(i)) else WRITEU, Unit, N_ELEMENTS(Tags.(i))
		WRITEU, Unit, Tags.(i)
	endfor

end