; Copyright (c) 1998-2016 A.P. Hitchcock, B. Watts  All rights reserved


;+
;NAME:
;	AXIS2000.PRO
;
;LAST CHANGED: -----------------------------------  20-Mar-16 aph (aph)
;
;PURPOSE:
;	This procedure starts the aXis2000 widget. 
;	It determines the program directory and initialization file
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:  AXIS2000, directory=directory, start_file='*.ini', , help=help, /dialog
;
;INPUTS: none
;
;KEYWORDS:
;	spin		activate spinning logo
;	help		print a help text
;
;OUTPUTS: starts execution of AXIS
;
;COMMON BLOCKS:
; axis_com
; sdf_com
;
; LIMITATIONS
; this has problems for MacOS (possibly all Unix ?) - when run from IDL preferences as startup command
; this procedure is not automatically compiled, so it generates the error message
; % Programs can't be compiled from single statement mode.
; if aXis2000 is then executed from the command line, it does auto-compile and executes properly
; SO the trick is NOT to put aXis2000 as the star-up, but rather axis2000_batch.pro
; which then compiles aXis2000.pr and runs it !!
;
;MODIFICATION HISTORY:
; (08-dec-00 cgz) first written
; (23-jan-01 cgz) Added initial specification of ini_file if start_file is not specified
; (23-jan-01 cgz) Added /help option to give help message
; (31-jan-01 aph) get so that will auto-run on PC from start_file call (redo of 12-jan-01 changes)
; (22-aug-01 aph) add spin keyword
; (28-jul-02 aph) set directory to 'CodePath' (from axis.ini file), if not defined in call
; (20-Apr-08 aph) explicitly force CodePath to 'c:\axis2000' if not exist
; (25-Jan-12 aph) adapt CodePath to deal with Mac versus Windows
; (20-May-13 bw ) Use internal IDL routines to get codepath to simplify and make more platform independent
; (27-May-13 aph) adapt to Windows so it will work with IDL version 6.3;  use as standard start file
; (14-Jan-14 aph) add @sdf_com - so now remembers last SDF file type
; (21-Jul-15 aph) activate auto detection of code path
; (20-Mar-16 aph) get generic version working for UNIX & Windows 
;-
;

PRO axis2000, spin=spin, directory=directory, help=help

@axis_com
@sdf_com

IF keyword_set(help) THEN BEGIN
    print,'aXis2000'
    print,'  Options include:'
	  print,'    directory = : path to folder with aXis2000 initialization file (aXis.ini)'
    print,'    /help   : to print this help text'
    print,'    /spin   : activate spinning logo'
    return
ENDIF

; ------ find the initialization file, "axis.ini"
; !!version.os       is one of linux, darwin (Mac OS X), sunos, Win32
; !version.os_family is either Unix or Windows

if !version.os_family EQ 'Windows' then begin
;    if float(!version.release) GT 7.0 then begin
;       CodePath = FILE_DIRNAME(ROUTINE_FILEPATH('axis2000'),/MARK)    ; only works for version 7.0 and higher
	ini_file = 'c:\aXis2000\axis_win.ini'

	ini_file = file_Search('axis_win.ini', /fully_qualify_path)
	if  strlen(ini_file) EQ 0 then  ini_file = file_Search('c:\aXis2000\axis_win.ini', /fully_qualify_path)
	if  strlen(ini_file) EQ 0 then  ini_file = file_Search('axis.ini', /fully_qualify_path)
	if  strlen(ini_file) EQ 0 then  ini_file = file_Search('c:\aXis2000\axis.ini', /fully_qualify_path)
    if  strlen(ini_file) EQ 0 then begin
      print, 'Cannot find either axis.ini or axis_win.ini files'
      print, 'define path to folder with the aXis2000 code in IDL preferences and try again'
      return
    endif
	t = ax_name(ini_file)
	CodePath=t(0)

endif else begin    ; for non-Windows OS (unix, incluing MacOS)
;  if float(!version.release) GT 7.0 then begin
;        CodePath = FILE_DIRNAME(ROUTINE_FILEPATH('axis2000'),/MARK)    ; only works for version 7.0 and higher
;  endif else begin
      ini_file = '/Users/aXis2000/axis_unix.ini'
 ;     help, ini_file
      if  strlen(ini_file) EQ 0 then begin
        print, 'Cannot find either the required axis_unix.ini file'
        print, 'Please create /Users/aXis2000 folder'
        print, 'and place the aXis2000 source code and the aXis2000.sav file into that folder'
        print, 'and restart IDL or the IDL virtual machine'
        return
      endif
;      t = ax_name(ini_file)
;      CodePath=t(0)
endelse

; print,'codepath : ',codepath
 print,'ini_file : ',ini_file

if keyword_set(spin) then axis_c, start_file = ini_file, /spin $
  else axis_c, start_file = ini_file

; axis_2000_abort :

return
end
