; Copyright (c) 1998-2013 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_RGB
;
;LAST CHANGED: ----------------------------------- 24-Apr-13 (aph)
;
; PURPOSE:
;	This procedure allows user to select 3 images from existing buffers
; and generates an RGB composite image, with optional storage.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	AX_RGB [, NO_SAVE=NO_SAVE]
;
;CALLED FROM AXIS:
;	->Utilities->RGB composite

;INPUTS: none
;
;KEYWORDS:
;	NO_SAVE  - do not ask for file name
;
;OUTPUTS: RGB image in MainImg and (optional) tif file on disk
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (18-sep-05 aph) first written; generated from images~RGB composite in axis_c
; (18-Mar-13 aph) add scale bar
; (24-Apr-13 aph)  remove scale_bar - inaccurate
;-

PRO ax_RGB, NO_SAVE=NO_SAVE, scalebar=scalebar
@axis_com
on_error,2

;  ************ Generate an RBG composite from 3 images *******
BufR = buffer(group = AXIS_ID, Prompt='select RED image')
HANDLE_VALUE, Data(BufR), tmpR
IF n_tags(tmpR) NE 0 THEN begin
	BufG = buffer(group = AXIS_ID, Prompt='select GREEN image')
	HANDLE_VALUE, Data(BufG), tmpG
	IF n_tags(tmpG) NE 0 THEN begin
		BufB = buffer(group = AXIS_ID, Prompt='select BLUE image')
		HANDLE_VALUE, Data(BufB), tmpB
		IF n_tags(tmpB) NE 0 THEN begin
			wset, MainImg
			disp3col,tmpR,tmpG,tmpB, /axis_on, channel=3	;displays 3-channel tif
		ENDIF ELSE axis_log, 'RGB files not fully defined'
	ENDIF ELSE axis_log, 'RGB files not fully defined'
ENDIF ELSE axis_log, 'RGB files not fully defined'

END
