   PRO CaptureWindow, event

      ; Get the default name of the file from the user value of the button.
      Widget_Control, event.id, Get_UValue=defaultFilename
      IF N_Elements(defaultFilename) EQ 0 THEN defaultFilename='capture.jpg'

      ; Ask for confirmation of the name of the output file.
      filename = Dialog_Pickfile(Title='Save Application Window As...', $
         Get_Path=theDir, Filter='*.jpg', /Write, File=defaultFilename)
      IF filename EQ "" THEN RETURN

      ; Make sure the window containing the button is the active window
      ; so it can be captured.
      Widget_Control, event.id, Input_Focus=1

      ; Capture the window.
      theFilename = StrMid(filename, StrLen(theDir))
      SPAWN, /NoShell, "C:\Program Files\PrintScreen\printscreen.exe " + $
                       "/dir='" + theDir + "' /file='" + theFilename + "' " + $
                       "/nosplash /exit /justnow /askfname='no' " + $
                       "/notaskbar /preview='no' /image='1' /cptarea='0' " + $
                       "/autoname='no'"

   END
