; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		ZIMBA_RUN.PRO
;
;LAST CHANGED: ----------------------------------- 	22 Jul 2014
;
; PURPOSE:
;	This  procedure executes Zstack_analyze outside of aXis2000
;   by loading data from individual files (*.sl, *.axb), with or without an alignment file
;   use it to generate movies with multiple spectra selected
;
; CATEGORY:
;	Image manipulation
;
; CALLING SEQUENCE:
; for procedures:
;	ZIMBA_RUN, AXIS=AXIS
;
; INPUTS:
; This section is for POSITIONAL INPUTS only (not keywords)
;	All input parameters are passed as keywords.
;
; KEYWORDS:
;	AXIS - if set, indicates AXIS widget exists and the user prompt dialog is used
;;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (26-sep-99 aph) first version (simplifying axis_c)
; (18-jan-00 aph) adapt to new zstack code (Jan-00)
; (22-Jul-14 aph) AXIS standard header added; add binary stack readin
;-

PRO ZIMBA_RUN, axis=axis
@axis_com
@bsif_common
@zstack_common
@zstack_analyze_common
@zstack_build_list_common
@zstack_align_common
@zstack_tune_common
@zstack_spectra_common
@zstack_profile_common
@zstack_save_common
@zstack_display_common
@zstack_color_common
on_error,2

if  keyword_set(AXIS) THEN BEGIN
	WIDGET_CONTROL, Uprompt, Bad_ID = BadID, SET_VALUE= 'Select file-list file'
endif else begin
	Print, 'Select file-list file'
	scan_file = dialog_pickfile(/READ, FILTER=['*.ncb','*.sl'],PATH = DefPath, GET_PATH =LPATH)
	binary_filename=scan_file
	DefPath = Lpath & Write_path = Lpath
	if strlen(scan_file) GT 0 THEN BEGIN  ; bail-out if no filename
		t=ax_name(scan_file)
		if t(2) EQ 'sl' then begin
		; ------ read in the *.sl file here and rewrite if needed
			test = stack_list(scan_file)
			if test EQ 0 then return		; BAIL if no valid SL file
			if  keyword_set(AXIS) THEN BEGIN
				WIDGET_CONTROL, Uprompt, Bad_ID = BadID, SET_VALUE= 'Select alignment data file'
			endif else Print, 'Select alignment data file'
			align_file = dialog_pickfile(/READ, FILTER='*.aln', PATH = DefPath, GET_PATH =LPATH)
			zoom_num= 1
			if strlen(align_file) GT 0 THEN BEGIN  ; bail-out if no filename
				Zstack_analyze, scan_file, align_file  ;,zoom=zoom_num
			endif else Zstack_analyze, scan_file ;, zoom=zoom_num
		endif else begin
			Zstack_analyze
		endelse
	endif else Zstack_analyze
endelse
END