FUNCTION Read_phi, file, NOFILTER=nof, DEFPATH=DefPath, _extra=e 
 
; + 
; function Read_Phi 
; (aph 25-nov-97)  reads Eli-format Phi XPS data (ALS BL7.0) 
;  (aph 21-feb-98) correct to save tmp.dn 
; - 
 
on_error,2 
if n_elements(file) eq 0 then begin  ;popup file dialog box 
   fltr='*.*' 
   if keyword_set(nof) then fltr='*' 
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath) 
endif 
 
if strlen(file) GT 0 THEN BEGIN 
    openr,unit,file,/get_lun 
    tst=strarr(1) 
	jumpn:                          ; get number of points 
        readf,unit, tst 
        q=strmid(tst(0),0,10) 
    	if q NE ';  NumPts=' then goto, jumpn 
    	npts=fix(strmid(tst(0),10,strlen(tst(0))-10)) 
    jumpx:                       ; find start of x-data 
    	readf,unit, tst 
    	if strmid(tst(0),0,2) NE 'x0' then goto, jumpx 
    x = fltarr(npts) 
    for i = 0,npts-1 do begin 
    	readf,unit,tst 
    	x(i)=float(tst(0)) 
    endfor 
    jumpy: 
    	readf,unit,tst 
    	if strmid(tst(0),0,3) NE ' y0' then goto, jumpy 
    y = fltarr(npts) 
    for i=0,npts-1 do begin 
    	readf,unit,tst 
    	y(i)=float(tst(0)) 
    endfor 
    close,unit 
 	xl='Energy'   &  dl ='Phi Intensity' 
 	upos = rstrpos(file,'/')       ; check for subdirectory separators 
 	wpos = rstrpos(file,'\') 
 	spos = max([upos,wpos]) 
 	if (spos ne -1) then file=strmid(file,spos+1,strlen(file)) 	; strip leader if it exists 
; 	spos=strpos(file,'.') 
; 	if (spos ne -1) then file=strmid(file,0,spos)		; strip extension 
 	file=strlowcase(file) 
 	dl = file 
 ; reverse direction of x, y if not increasing 
 	if x(npts-1) LT x(0) then begin 
 	  x = reverse(x) 
 	  y = reverse(y) 
 	endif 
 	s={t:'1d', x: x, d: y, xl: xl, dn: y, dl: dl} 
endif else begin 	; go here if user pushes 'cancel' 
    print, ' file name of zero length. Read aborted' 
    s=0 
endelse 
return, s 
end 
 
 
 
 
 
