; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	THUMBLBLS
;
;LAST CHANGED: ----------------------------------- 16-Feb-2010
;
;PURPOSE:
;	ThumbLbls display the thumbnail sketches used for buffer identification
;
;CATEGORY:
;	AXIS:  utility (captive)
;
;CALLING SEQUENCE:
;	ThumbLbls, /ALL
;
;CALLED FROM AXIS:
;	whenever execute PlotBuf to display a new Buffer; clear; etc
;
 ;INPUTS: none
;
;KEYWORDS:
;	ALL  - force all 9 to be redsiplayed
;
;OUTPUTS:
;	revised AXIS display
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (   MAR-98 APH) split from axis_c to shrink file
; (14-jun-98 aph) axis_com
; (24-jun-99 aph) consistent color for image/spectra ; ADD zstack_color_common
; (26-jul-99 aph) if curBuf=0, only update labels
; (26-sep-99 aph) separated from THUMBS.PRO to have file name = run name
;                adapted to 9 separate windows
; (31-jan-00 aph) AXIS standard documentation; re-ordered to avoid loss of utility routines
; (11-mar-00 aph) remove comment on @axis_com line
; (16-apr-00 aph) handle 3d images which have 3-channel (3-d) data structure
; (19-dec-00 cgz) substituted ax_white_color_index with ax_plot_axes_color_index
;			substituted ax_black_color_index with ax_plot_bkgd_color_index
; (16-Feb-10 aph) separated from parent Thumblbls.pro file to follow IDL conventions
;-

PRO ThumbLbls, ALL = ALL

@axis_com
on_error,2

BLbl_upd		; update all labels

if keyword_set(all) then begin
	FOR i = 1, 9 DO ThumbPlot, i
ENDIF else ThumbPlot, CurBuf
Wset, MainImg
END
