; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	GET_PATH.PRO 
; 
;LAST CHANGED: ----------------------------------- 20-May-00 
; 
;PURPOSE: 
;	This function find the location of 'FILE1' 
; It is used in filename list processing to get around fact that 
; files are frequently moved and thus have different paths 
; The valid path to 'file1' is returned (with correct separator for the host computer) 
; or '' (empty string) if this cannot be found 
; 
;CATEGORY: 
;	AXIS:  utility (operates stand alone) 
; 
;CALLING SEQUENCE: 
;	Result = GET_PATH(file1, list=list) 
; 
;CALLED FROM AXIS: 
;	various places 
; 
;ROUTINES 
;	if the file contains multiple PROs 
; list these here, along with a brief description of their function 
; 
;INPUTS: 
;	INPUT - POSITIONAL INPUTS only (not keywords) 
;	All input parameters are passed as keywords. 
; 
;KEYWORDS: 
;	LIST = name of file containing list of file names 
; 
;OUTPUTS: 
; Path to file1 is returned 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;PROCEDURE: 
; If the path associated with 'file1' is not correct, various 
; plausible locations are checked (defPath, the current default path in AXIS) 
; and the user is requested to locate the file by using pickfile dialog 
; if the file is not found through 3 search strategies, an empty string is returned 
; 
;MODIFICATION HISTORY: 
; (15-jun-99 aph) first version 
; (18-jul-99 aph) rewrote to be more flixible 
; (20-May-00 aph) AXIS standard documentation 
;- 
 
function get_path, file1, list=list 
 
@axis_com
on_error,2 
 
sep = ax_sep() 
t = ax_name(file1) 
DataPath = t(0) 
fname = t(1) + '.' + t(2)    ; generate name from stripped off name, extension 
q = findfile(file1, count = cnt) 
if cnt EQ 0 then begin		; file does not exist 
	print, 'Cannot find file: ', fname , ' in path: ', t(0) 
	DataPath = DefPath 
	print, '....checking the default path:', DataPath 
	file2 = DataPath + fname 
	q = findfile(file2, count = cnt2) 
	if cnt2 EQ 0 then begin 
; --------- is it in same directory as filename_list ? 
		if keyword_set(list) then begin 
			t = ax_name(list(0)) 
			flist = t(0) 
			print, '....checking the list file path: ', flist 
			file2 = flist+fname 
	 		q = findfile(file2, count = cnt3) 
	 		if cnt3 EQ 0 then begin		;  otherwise ask the user 
				WIDGET_CONTROL, Uprompt, Bad_ID = badID, SET_VALUE='find location of datafiles' 
	 			file2=PICKFILE2(/Read, FILTER='*.*', /LPATH, DEFPATH=defpath) 
	 			if strlen(file2) EQ 0 then goto, cancel 
			endif 
		endif else begin 
;------------- otherwise ask the user 
			WIDGET_CONTROL, Uprompt, Bad_ID = badID, SET_VALUE='find location of datafiles' 
			file2=PICKFILE2(/Read, FILTER='*.*', /LPATH, DEFPATH=defpath) 
			if strlen(file2) EQ 0 then goto, cancel 
		endelse 
	endif 
	t = ax_name(file2) 
	DataPath = t(0) 
; --- check indeed that the data file exists in the defined path 
	print, '....Get_Path thinks data path is ', dataPath 
	q = findfile(DataPath+fname, count = cnt4) 
	if cnt4 eq 0 then goto, cancel 
endif 
 
DataPath = DataPath 
print, 'Path is: ', dataPath 
return, DataPath 
 
cancel: 
print, 'Path not found' 
DataPath = '' 
return, DataPath 
end 
