; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SXM_FILEEXIST
;
;LAST CHANGED: ----------------------------------- 	22 Jul 2014
;
; PURPOSE:
;	This function checks existence of a file (normally use findfile)
; ; Returns 1 if the file exists, 0 otherwise.
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
; for procedures:
;	ZOOM [, FACT = Fact, /INTERP, XSIZE = Xs, YSIZE = Ys, /CONTINUOUS, $
;		/KEEP, ZOOM_WINDOW=Zoom_Win, /NEW_WINDOW ]
; for functions:
;	Result = Sxm_fileexists (filename, [nofindfile=nofindfile])
;
; INPUTS:
;	filename - name of file
;
; KEYWORDS:
;	nofindfile	error value (0 if not found, 1 if found)
;
; MODIFICATION HISTORY:
; (21-Dec-00 cjj) file obtained from CJJ's source
; (22-Jul-14 aph) AXIS standard header added
;-

FUNCTION Sxm_fileexists, filename, nofindfile=nofindfile

IF keyword_set(nofindfile) THEN BEGIN
    get_lun, lun
    openr, lun, filename, error = code
    IF (code EQ 0) THEN BEGIN
        returnval = 1
    ENDIF ELSE BEGIN
        returnval = 0
    ENDELSE
    close, lun
    free_lun, lun
ENDIF ELSE BEGIN
    temp = findfile(filename)
    svec = size(temp)
    IF (svec(0) EQ 0) THEN BEGIN
        ; Got a single null string, so file does not exist
        returnval = 0
    ENDIF ELSE BEGIN
        returnval = 1
    ENDELSE
ENDELSE

return, returnval
END

