; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_MACRO
;
;LAST CHANGED: ----------------------------------- 21-Jul-14
;
; PURPOSE:
;	This sequence of commands is a MACRO
; which is inserted into aXis2000 at the command Utilities~execute Macro
; whenever program is restarted OR axis_c is compiled
;
; CATEGORY:
;	user modifiable command sequence
;
; CALLING SEQUENCE:
;  Utilities~execute Macro - captive to axis2000
;
; INPUTS: none (incorporate in commands)
;
; KEYWORDS: none (incorporate in commands)
;
; OUTPUTS:
;
; COMMON BLOCKS: none
;
; SIDE EFFECTS: none
;
; RESTRICTIONS:
; **********************************************************
;	COMMANDS KNOWN TO BE EXECUTABLE AS A MACRO - see those files for details
;	ax_rotate - rotate and mesh images
;	ax_zoom_cut	- numerically truncate and re-mesh images
;
; MODIFICATION HISTORY:
; (31-dec-01 aph) first introduced into aXis2000
; (02-mar-04 aph) modified header
; (21-Jul-14 aph) corrected header
;-
;
; PLEASE DATE AND EXPLAIN WHAT YOUR MACRO IS INTENDED TO DO
;
; (31-dec-01 aph) converts toner particle component maps to standard size for assembley
;			sections 1-10 have different centre than sections 11-25
;
ax_rotate, angle= 0.0001, centre = [0.,0.], maxdist= 13., pixelsize=0.09, /minval
ax_zoom_cut, limits=[-6.8,7.2,-8.46,5.54], mesh = [156,156]
