; Copyright (c) 1998-2017 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		MBUF.PRO
;
;LAST CHANGED: ----------------------------------- 10-Jul-17 (bw 26-May-2017)
;
; PURPOSE:
;	This function is a widget that allows selection of multiple buffers
;
; CATEGORY:
;	utility captive to axis2000
;
; CALLING SEQUENCE:
;	Result = MBUF(group = group, Val = val)
;
; INPUTS:
;	All input parameters are passed as keywords.
;
; KEYWORDS:
;	GROUP	identity of parent group that called mbuf (axis_id)
;	val 	array of buffers for default selection
;
; OUTPUTS:
;  returns array with numbers of selected buffers
;
; COMMON BLOCKS:
;	COMMON Buffer, BGROUP16, MBufs, cncl
;
; SIDE EFFECTS:
;	A widget is created/destroyed.

; MODIFICATION HISTORY:
; (13-dec-98 aph) correct layout; all, cancel added
; (20-aug-01 aph) removed modal call at xmanager
; (31-dec-01 aph) when select 'all' it includes buffer 0
; (15-Jan-13 aph) force Mbuf to track aXis2000 widget
; (21-Jul-14 aph) corrected header
; (26-May-17 bw)  add small wait before realizing widget in order to fix linux bug
; (10-jul-17 aph) checked OK for windows
;-

PRO MBuf_Event, Event
COMMON Buffer, BGROUP16, MBufs, cncl
on_error,2
  WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev

  CASE Ev OF

  'BUTTON9': BEGIN
    WIDGET_CONTROL, BGROUP16, GET_VALUE=MBufs
    WIDGET_CONTROL, Event.Top, /DESTROY
    MBufs(10)=0
      END

  'BUTTON8': BEGIN
    WIDGET_CONTROL, BGROUP16, GET_VALUE=MBufs
    WIDGET_CONTROL, Event.Top, /DESTROY
    CNCL = 1
      END

  'BGROUP16': BEGIN
      CASE Event.Value OF
      0:
      1:
      2:
      3:
      4:
      5:
      6:
      7:
      8:
      9:
      10: BEGIN
      	 BufStat = intarr(10)
      	 for i = 0,9 do begin
      	 	BufStat(i) = 1
      	 endfor
      	 WIDGET_CONTROL, Bgroup16, SET_VALUE = BufStat
      	 END

      ELSE: Message,'Unknown button pressed'
      ENDCASE
      END
  ENDCASE
END


Function MBuf, GROUP=Group, VAL = val
; (aph 17-jun-97) set non-exclusive buttons to list in VAL (if present); let user modify

COMMON Buffer, BGROUP16, MBufs, cncl
on_error,2
cncl=0
modal_val=1
 IF N_ELEMENTS(Group) EQ 0 THEN begin
	GROUP=0
	modal_val=0
 endif


junk   = { CW_PDMENU_S, flags:0, name:'' }

MBuf = WIDGET_BASE(GROUP_LEADER=Group, $
  MAP=1, $
  modal = modal_val, $
 ; XOFFSET = 360, $		; try removing this to force Mbuf to track aXis2000 widget - YES !!
 ; YOFFSET = 50, $
  UVALUE='MBuf')

BUTTON9 = WIDGET_BUTTON( MBuf, $
  FRAME=1, $
  UVALUE='BUTTON9', $
  VALUE='Done', $
  XOFFSET=5, $
  YOFFSET=4)

BUTTON8 = WIDGET_BUTTON( MBuf, $
  FRAME=1, $
  UVALUE='BUTTON8', $
  VALUE='Cancel', $
  XOFFSET=60, $
  YOFFSET=5)

Btns1877 = [ $
	'1', $
	'2', $
	'3', $
	'4', $
	'5', $
	'6', $
	'7', $
	'8', $
	'9', $
	'0', $
	'all' ]

BGROUP16 = CW_BGROUP( MBuf, Btns1877, $
	Row = 4, $
	YOFFSET = 30, $
	NONEXCLUSIVE=1, $
	LABEL_TOP='Select Buffers', $
	UVALUE='BGROUP16')

 Mbufs = intarr(10)
 WAIT, 0.1
 WIDGET_CONTROL, MBuf, /REALIZE
 IF Keyword_Set(val) THEN BEGIN
	BufStat = intarr(10)
	 tmp = size(val) & pNum = tmp(1)   ;indicate the buffers currently plotted
	 For i = 0, pNum-1 DO BEGIN
	 	if val(i) NE 0 THEN  BufStat(val(i)-1) = 1
	 	if val(i) EQ 0 then BufStat(9) = 1
	 ENDFOR
	WIDGET_CONTROL, Bgroup16, SET_VALUE = BufStat
  ENDIF

  XMANAGER, 'MBuf', MBuf
;  Print, 'Done gives', MBufs
  IF cncl EQ 1 OR total(Mbufs) EQ 0 THEN BEGIN
  	RETURN,-1
  	ENDIF ELSE BEGIN
	  TempBufs = SHIFT(MBufs, 1)
	  MBufs = INTARR(1)
	  FOR i = 0, 9 DO BEGIN
	  	IF TempBufs(i) EQ 1 THEN MBufs = [MBufs, i]
	  ENDFOR
	  If TempBufs(10) EQ 1 then MBufs = [MBufs, 0]
	  Tmp = SIZE(MBufs)
	  TBufs = INTARR(Tmp(1) - 1)
	  FOR i = 0, Tmp(1) - 2 DO BEGIN
	  	TBufs(i) = MBufs(i + 1)
	  ENDFOR
	  RETURN, TBufs
	ENDELSE
END
