; Copyright (c) 1998-2025 A.P. Hitchcock, B. Watts  All rights reserved
;+
;NAME:
;		NEXUS_COM.PRO
;
;LAST CHANGED: ----------------------------------- 	05-Jan-2025 (from 23 May 2019) (aph)
;
; PURPOSE:
;	This file contains the common block for the widget which reads NeXus files
;
; CATEGORY:
;	utility
;
; DEFINITIONS - please update if you extend this common block
;
; nexus					ID of ax_nexus widget
; nexus_head
; NEXUS_ID
; NEXUS_Channel_List	array of detector channel numbers
; NEXUS_Region_List		array of spatial region numbers
; nexus_image			index of the image in a stack
; nexus_ch				number of currently selected detector channel
; nexus_region			number of currently selected spatial region
; nexus_dwell    		dwell time (ms)
; nexus_flip			if set, flip the image
; nexus_map				if set, compute stack map
; nexus_path			path to NeXus files
; nexus_lastfile		filename
; draw_nexus			WidgetID of draw widget
; NexusImg				draw window ID value (not same as WidgetID )
; Nexus_no_save			flag - if set, do not auto-save the file read
; AX_NEXUS_VIEWER_ID    location of the base for AX_NEXUS_VIEWER
; anv_folder			last folder where aX-nexus_viewer was applied
; anv_filelist			list of hdf5 files to view
; anv_current_file		index of the currently viewed file
; ANV_NexusImg			identify of Draw widget to display the data
; preview_flag			flag - if set read & display ; if = 0 do not read until 'OK'
; ptycho_flag			flag - if set, turn on "ptycho-read" mode in read_nexus
; nexus_source          'pySTXM'  or 'pixelator'
; nexus_norm_value		ring current normalization (pySTXM = 200 mA; pixelator = 500 mA  defaults
;
; MODIFICATION HISTORY:
; (27-Apr-15 bw ) First version written using sdf_com.pro as a template
; (13-Jul-15 aph) integrated into aXis2000 02-July-15 version
; (04-Apr-16 aph) add ID of the display window
; (08-May-16 aph) add parameters needed for AX_NEXUS_VIEWER
; (21-Mar-18 aph) add preview_flag, nexus_source
; (15-May-18 aph) add nexus_norm_value
; (23-May-19 aph) add ptycho_flag
; (29-Dec-24 aph) ass NEXUS_map flag
;-


COMMON NEXUS_EVENT, nexus, nexus_head, NEXUS_ID, NEXUS_Channel_List, $
      NEXUS_Region_List, nexus_image, nexus_ch, nexus_region,  nexus_dwell, nexus_path, nexus_lastfile, $
      draw_nexus, NexusImg, Nexus_no_save, Nexus_map, AX_NEXUS_VIEWER_ID, anv_folder, ptycho_flag, $
      anv_filelist, anv_current_file, ANV_NexusImg, NEXUS_flip, preview_flag, nexus_source, nexus_norm_value